/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class SchemaSuggestions {
    private Hashtable<String, Element> htFields = new Hashtable();

    public SchemaSuggestions(Path xmlSuggestFile) throws Exception {
        Element sugg = Xml.loadFile((Path)xmlSuggestFile);
        List list = sugg.getChildren();
        for (Element el : list) {
            if (!el.getName().equals("field")) continue;
            this.htFields.put(el.getAttributeValue("name"), el);
        }
    }

    private boolean isX(String parent, String child, String what) {
        Element fieldEl = this.htFields.get(parent);
        if (fieldEl == null) {
            return false;
        }
        List list = fieldEl.getChildren();
        for (Element elem : list) {
            String name;
            if (!elem.getName().equals(what) || !child.equals(name = elem.getAttributeValue("name"))) continue;
            return true;
        }
        return false;
    }

    public boolean isSuggested(String parent, String child) {
        return this.isX(parent, child, "suggest");
    }

    public boolean isFiltered(String parent, String child) {
        return this.isX(parent, child, "filter");
    }

    public boolean hasSuggestion(String parent, List<String> childElements) {
        Element el = this.htFields.get(parent);
        if (el == null) {
            return false;
        }
        for (String child : childElements) {
            if (!this.isSuggested(parent, child)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSuggestedElements(String elementName) {
        Element suggestionConfig = this.htFields.get(elementName);
        ArrayList<String> suggestedElement = new ArrayList<String>();
        if (suggestionConfig == null) {
            return suggestedElement;
        }
        for (Object object : suggestionConfig.getChildren()) {
            Element suggestion = (Element)object;
            if (!suggestion.getName().equals("suggest")) continue;
            String name = suggestion.getAttributeValue("name");
            suggestedElement.add(name);
        }
        return suggestedElement;
    }
}

