/*
 * Decompiled with CFR 0.152.
 */
package jeeves.monitor;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.DummyCounter;
import com.yammer.metrics.core.DummyHistogram;
import com.yammer.metrics.core.DummyMeter;
import com.yammer.metrics.core.DummyTimer;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.log4j.InstrumentedAppender;
import com.yammer.metrics.reporting.JmxReporter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import jeeves.monitor.GeonetworkJmxReporter;
import jeeves.monitor.HealthCheckFactory;
import jeeves.monitor.MetricsFactory;
import jeeves.monitor.ResourceTracker;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.fao.geonet.Util;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class MonitorManager {
    public static final String HEALTH_CHECK_REGISTRY = "com.yammer.metrics.reporting.HealthCheckServlet.registry";
    public static final String CRITICAL_HEALTH_CHECK_REGISTRY = "com.yammer.metrics.reporting.HealthCheckServlet.registry.critical";
    public static final String WARNING_HEALTH_CHECK_REGISTRY = "com.yammer.metrics.reporting.HealthCheckServlet.registry.warning";
    public static final String EXPENSIVE_HEALTH_CHECK_REGISTRY = "com.yammer.metrics.reporting.HealthCheckServlet.registry.expensive";
    public static final String METRICS_REGISTRY = "com.yammer.metrics.reporting.MetricsServlet.registry";
    private final List<HealthCheckFactory> criticalServiceContextHealthChecks = new LinkedList<HealthCheckFactory>();
    private final List<HealthCheckFactory> warningServiceContextHealthChecks = new LinkedList<HealthCheckFactory>();
    private final List<HealthCheckFactory> expensiveServiceContextHealthChecks = new LinkedList<HealthCheckFactory>();
    private final Map<Class<MetricsFactory<Gauge<?>>>, Gauge<?>> serviceContextGauges = new HashMap();
    private final Map<Class<MetricsFactory<Timer>>, Timer> serviceContextTimers = new HashMap<Class<MetricsFactory<Timer>>, Timer>();
    private final Map<Class<MetricsFactory<Counter>>, Counter> serviceContextCounters = new HashMap<Class<MetricsFactory<Counter>>, Counter>();
    private final Map<Class<MetricsFactory<Histogram>>, Histogram> serviceContextHistogram = new HashMap<Class<MetricsFactory<Histogram>>, Histogram>();
    private final Map<Class<MetricsFactory<Meter>>, Meter> serviceContextMeter = new HashMap<Class<MetricsFactory<Meter>>, Meter>();
    ResourceTracker resourceTracker = new ResourceTracker();
    private HealthCheckRegistry healthCheckRegistry;
    private HealthCheckRegistry criticalHealthCheckRegistry;
    private HealthCheckRegistry warningHealthCheckRegistry;
    private HealthCheckRegistry expensiveHealthCheckRegistry;
    private MetricsRegistry metricsRegistry;
    private JmxReporter jmxReporter;
    private ServiceContext monitorContext;

    public void init(ServletContext context, String baseUrl) {
        String webappName = "";
        if (StringUtils.isNotEmpty((String)baseUrl)) {
            webappName = baseUrl.substring(1);
        }
        if (context != null) {
            HealthCheckRegistry tmpHealthCheckRegistry = this.lookUpHealthCheckRegistry(context, HEALTH_CHECK_REGISTRY);
            HealthCheckRegistry criticalTmpHealthCheckRegistry = this.lookUpHealthCheckRegistry(context, CRITICAL_HEALTH_CHECK_REGISTRY);
            HealthCheckRegistry warningTmpHealthCheckRegistry = this.lookUpHealthCheckRegistry(context, WARNING_HEALTH_CHECK_REGISTRY);
            HealthCheckRegistry expensiveTmpHealthCheckRegistry = this.lookUpHealthCheckRegistry(context, EXPENSIVE_HEALTH_CHECK_REGISTRY);
            this.healthCheckRegistry = tmpHealthCheckRegistry;
            this.criticalHealthCheckRegistry = criticalTmpHealthCheckRegistry;
            this.warningHealthCheckRegistry = warningTmpHealthCheckRegistry;
            this.expensiveHealthCheckRegistry = expensiveTmpHealthCheckRegistry;
            MetricsRegistry tmpMetricsRegistry = (MetricsRegistry)context.getAttribute(METRICS_REGISTRY);
            if (tmpMetricsRegistry == null) {
                tmpMetricsRegistry = new MetricsRegistry();
            }
            this.metricsRegistry = tmpMetricsRegistry;
            context.setAttribute(METRICS_REGISTRY, (Object)tmpMetricsRegistry);
            this.jmxReporter = new GeonetworkJmxReporter(this.metricsRegistry, webappName);
            this.jmxReporter.start();
        } else {
            this.healthCheckRegistry = new HealthCheckRegistry();
            this.criticalHealthCheckRegistry = new HealthCheckRegistry();
            this.warningHealthCheckRegistry = new HealthCheckRegistry();
            this.expensiveHealthCheckRegistry = new HealthCheckRegistry();
            this.metricsRegistry = new MetricsRegistry();
            this.jmxReporter = new GeonetworkJmxReporter(this.metricsRegistry, webappName);
            this.jmxReporter.start();
        }
        LogManager.getRootLogger().addAppender((Appender)new InstrumentedAppender(this.metricsRegistry));
    }

    private HealthCheckRegistry lookUpHealthCheckRegistry(ServletContext context, String attributeKey) {
        HealthCheckRegistry tmpHealthCheckRegistry = (HealthCheckRegistry)context.getAttribute(attributeKey);
        if (tmpHealthCheckRegistry == null) {
            tmpHealthCheckRegistry = new HealthCheckRegistry();
        }
        context.setAttribute(attributeKey, (Object)tmpHealthCheckRegistry);
        return tmpHealthCheckRegistry;
    }

    public void initMonitorsForApp(ServiceContext initContext) {
        Gauge instance;
        ServiceManager serviceManager = initContext.getBean(ServiceManager.class);
        this.monitorContext = serviceManager.createServiceContext("monitor", initContext);
        this.createHealthCheck(this.monitorContext, this.criticalServiceContextHealthChecks, this.criticalHealthCheckRegistry, "critical health check");
        this.createHealthCheck(this.monitorContext, this.warningServiceContextHealthChecks, this.warningHealthCheckRegistry, "warning health check");
        this.createHealthCheck(this.monitorContext, this.expensiveServiceContextHealthChecks, this.expensiveHealthCheckRegistry, "expensive health check");
        for (Class clazz : this.serviceContextGauges.keySet()) {
            Log.info((String)"jeeves.engine", (Object)("Instantiating : " + clazz.getName()));
            instance = (Gauge)this.create(clazz, this.monitorContext, "gauge");
            this.serviceContextGauges.put(clazz, instance);
        }
        for (Class clazz : this.serviceContextTimers.keySet()) {
            Log.info((String)"jeeves.engine", (Object)("Instantiating : " + clazz.getName()));
            instance = (Timer)this.create(clazz, this.monitorContext, "timer");
            this.serviceContextTimers.put(clazz, (Timer)instance);
        }
        for (Class clazz : this.serviceContextCounters.keySet()) {
            Log.info((String)"jeeves.engine", (Object)("Instantiating : " + clazz.getName()));
            instance = (Counter)this.create(clazz, this.monitorContext, "counter");
            this.serviceContextCounters.put(clazz, (Counter)instance);
        }
        for (Class clazz : this.serviceContextHistogram.keySet()) {
            Log.info((String)"jeeves.engine", (Object)("Instantiating : " + clazz.getName()));
            instance = (Histogram)this.create(clazz, this.monitorContext, "histogram");
            this.serviceContextHistogram.put(clazz, (Histogram)instance);
        }
        for (Class clazz : this.serviceContextMeter.keySet()) {
            Log.info((String)"jeeves.engine", (Object)("Instantiating : " + clazz.getName()));
            instance = (Meter)this.create(clazz, this.monitorContext, "meter");
            this.serviceContextMeter.put(clazz, (Meter)instance);
        }
    }

    private void createHealthCheck(ServiceContext context, List<HealthCheckFactory> checks, HealthCheckRegistry registry, String type) {
        ServiceManager serviceManager = context.getBean(ServiceManager.class);
        for (HealthCheckFactory healthCheck : checks) {
            String factoryName = healthCheck.getClass().getName();
            try {
                HealthCheck check = healthCheck.create(context);
                Log.info((String)"jeeves.engine", (Object)("Registering " + type + ": " + factoryName));
                this.healthCheckRegistry.register(check);
                registry.register(check);
            }
            catch (Throwable t) {
                Log.info((String)"jeeves.engine", (Object)("Unable to register " + type + ": " + factoryName));
            }
        }
    }

    private <T> T create(Class<MetricsFactory<T>> factoryClass, ServiceContext context, String type) {
        try {
            MetricsFactory<T> instance = factoryClass.newInstance();
            return instance.create(this.metricsRegistry, context);
        }
        catch (Exception e) {
            this.logReflectionError(e, factoryClass.getName(), type);
            return null;
        }
    }

    public void initMonitors(Element monitors) {
        this.info("Initializing monitors...");
        String pack = monitors.getAttributeValue("package");
        this.initHealthChecks(monitors, pack, "criticalHealthCheck", this.criticalServiceContextHealthChecks);
        this.initHealthChecks(monitors, pack, "warningHealthCheck", this.warningServiceContextHealthChecks);
        this.initHealthChecks(monitors, pack, "expensiveHealthCheck", this.expensiveServiceContextHealthChecks);
        for (Element gauge : monitors.getChildren("gauge")) {
            this.serviceContextGauges.put(this.loadClass(gauge, pack, "gauge"), null);
        }
        this.serviceContextGauges.remove(null);
        for (Element gauge : monitors.getChildren("counter")) {
            this.serviceContextCounters.put(this.loadClass(gauge, pack, "gauge"), null);
        }
        this.serviceContextCounters.remove(null);
        for (Element gauge : monitors.getChildren("timer")) {
            this.serviceContextTimers.put(this.loadClass(gauge, pack, "timer"), null);
        }
        this.serviceContextTimers.remove(null);
        for (Element gauge : monitors.getChildren("histogram")) {
            this.serviceContextHistogram.put(this.loadClass(gauge, pack, "histogram"), null);
        }
        this.serviceContextHistogram.remove(null);
        for (Element gauge : monitors.getChildren("meter")) {
            this.serviceContextMeter.put(this.loadClass(gauge, pack, "meter"), null);
        }
        this.serviceContextMeter.remove(null);
    }

    private void initHealthChecks(Element monitors, String pack, String tagName, List<HealthCheckFactory> checkCollection) {
        for (Element check : monitors.getChildren(tagName)) {
            Class hcClass = this.loadClass(check, pack, tagName);
            try {
                checkCollection.add((HealthCheckFactory)hcClass.newInstance());
            }
            catch (Exception e) {
                this.logReflectionError(e, hcClass != null ? hcClass.getName() : "unknown", tagName);
            }
        }
    }

    private <T> Class<T> loadClass(Element monitor, String pack, String type) {
        String name = monitor.getAttributeValue("class");
        this.info("   Adding " + type + ": " + name);
        String className = name;
        if (name.startsWith(".")) {
            className = pack + name;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            this.logReflectionError(e, className, type);
            return null;
        }
    }

    private void logReflectionError(Exception e, String className, String type) {
        this.error("Raised exception while registering " + type + ". Skipped.");
        this.error("   Class name  : " + className);
        this.error("   Exception : " + e);
        this.error("   Message   : " + e.getMessage());
        this.error("   Stack     : " + Util.getStackTrace((Throwable)e));
    }

    private void info(String s) {
        Log.info((String)"jeeves.monitor", (Object)s);
    }

    private void error(String s) {
        Log.error((String)"jeeves.monitor", (Object)s);
    }

    public Counter getCounter(Class<? extends MetricsFactory<Counter>> type) {
        Counter instance = this.serviceContextCounters.get(type);
        if (instance == null) {
            return DummyCounter.INSTANCE;
        }
        return instance;
    }

    public Timer getTimer(Class<? extends MetricsFactory<Timer>> type) {
        Timer instance = this.serviceContextTimers.get(type);
        if (instance == null) {
            return DummyTimer.INSTANCE;
        }
        return instance;
    }

    public Histogram getHistogram(Class<? extends MetricsFactory<Histogram>> type) {
        Histogram instance = this.serviceContextHistogram.get(type);
        if (instance == null) {
            return DummyHistogram.INSTANCE;
        }
        return instance;
    }

    public Meter getMeter(Class<? extends MetricsFactory<Meter>> type) {
        Meter instance = this.serviceContextMeter.get(type);
        if (instance == null) {
            return DummyMeter.INSTANCE;
        }
        return instance;
    }

    public ResourceTracker getResourceTracker() {
        return this.resourceTracker;
    }

    @PreDestroy
    public void shutdown() {
        Log.info((String)"jeeves.engine", (Object)"MonitorManager#shutdown");
        if (this.monitorContext != null) {
            this.monitorContext.clear();
        }
        if (this.resourceTracker != null) {
            this.resourceTracker.clean();
        }
        if (this.jmxReporter != null) {
            this.jmxReporter.shutdown();
        }
    }
}

