/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.NodeInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class JeevesDispatcherServlet
extends DispatcherServlet {
    protected void doDispatch(final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        TransactionManager.runInTransaction("jeevesDispatchServlet", (ApplicationContext)this.getWebApplicationContext(), TransactionManager.TransactionRequirement.CREATE_ONLY_WHEN_NEEDED, TransactionManager.CommitBehavior.ONLY_COMMIT_NEWLY_CREATED_TRANSACTIONS, false, new TransactionTask<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus transaction) throws Throwable {
                JeevesDispatcherServlet.this.setNodeId(request);
                JeevesDispatcherServlet.super.doDispatch(request, response);
                return null;
            }
        });
    }

    protected WebApplicationContext findWebApplicationContext() {
        ServletContext servletContext = this.getServletContext();
        return this.createWebApplicationContext((ApplicationContext)servletContext.getAttribute("jeevesNodeApplicationContext_"));
    }

    private void setNodeId(HttpServletRequest request) {
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        if (node == null) {
            return;
        }
        String path = request.getPathInfo();
        if (path != null && path.length() > 1 && path.contains("/")) {
            String id = request.getPathInfo().split("/")[1];
            node.setId(NodeInfo.EXCLUDED_NODE_IDS.contains((Object)id) ? "srv" : id);
        } else {
            node.setId("srv");
        }
    }
}

