/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.regex.Pattern;
import org.geotools.jdbc.VirtualTableParameter;

public class RegexpValidator
implements VirtualTableParameter.Validator {
    Pattern pattern;

    public RegexpValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegexpValidator(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public void validate(String value) throws IllegalArgumentException {
        if (!this.pattern.matcher(value).matches()) {
            throw new IllegalArgumentException("Value " + value + " does not match " + this.pattern.pattern());
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexpValidator other = (RegexpValidator)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.pattern().equals(other.pattern.pattern()));
    }
}

