/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.LessSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;

public class HiddenTokenAwareTree
extends CommonTree
implements Cloneable {
    private final LessSource source;
    private List<CommonToken> preceding = new LinkedList<CommonToken>();
    private List<CommonToken> orphans = new LinkedList<CommonToken>();
    private List<CommonToken> following = new LinkedList<CommonToken>();
    private CommonToken tokenAsCommon;

    public HiddenTokenAwareTree(CommonToken payload, LessSource source) {
        super((Token)payload);
        this.source = source;
        this.tokenAsCommon = payload;
    }

    public HiddenTokenAwareTree(LessSource source) {
        this.source = source;
    }

    public HiddenTokenAwareTree(CommonTree node, LessSource source) {
        super(node);
        this.source = source;
    }

    public LessSource getSource() {
        return this.source;
    }

    public HiddenTokenAwareTree getChild(int i) {
        return (HiddenTokenAwareTree)super.getChild(i);
    }

    public List<HiddenTokenAwareTree> getChildren() {
        List<HiddenTokenAwareTree> result = super.getChildren();
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public boolean hasChildren() {
        List children = super.getChildren();
        return children != null && !children.isEmpty();
    }

    public HiddenTokenAwareTree getParent() {
        return (HiddenTokenAwareTree)super.getParent();
    }

    public List<CommonToken> getPreceding() {
        return this.preceding;
    }

    public List<CommonToken> chopPreceedingUpToLastOfType(int type) {
        ArrayList<CommonToken> result = new ArrayList<CommonToken>();
        List<CommonToken> preceding = this.getPreceding();
        int index = this.lastTokenOfType(preceding, type);
        for (int i = 0; i <= index; ++i) {
            CommonToken next = preceding.remove(0);
            result.add(next);
        }
        return result;
    }

    private int lastTokenOfType(List<CommonToken> list, int type) {
        if (list.isEmpty()) {
            return -1;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Token token = (Token)list.get(i);
            if (token.getType() != type) continue;
            return i;
        }
        return -1;
    }

    public List<CommonToken> getFollowing() {
        return this.following;
    }

    public List<CommonToken> getOrphans() {
        return this.orphans;
    }

    public void addPreceding(CommonToken token) {
        this.preceding.add(token);
    }

    public void addPreceding(List<CommonToken> tokens) {
        this.preceding.addAll(tokens);
    }

    public void addBeforePreceding(List<CommonToken> tokens) {
        this.preceding.addAll(0, tokens);
    }

    public void addOrphan(CommonToken token) {
        this.orphans.add(token);
    }

    public void addOrphans(List<CommonToken> tokens) {
        this.orphans.addAll(tokens);
    }

    public void addFollowing(CommonToken token) {
        this.following.add(token);
    }

    public void addBeforeFollowing(List<CommonToken> tokens) {
        this.following.addAll(0, tokens);
    }

    public void addFollowing(List<CommonToken> tokens) {
        this.following.addAll(tokens);
    }

    public void pushHiddenToKids() {
        List<HiddenTokenAwareTree> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        HiddenTokenAwareTree first = children.get(0);
        first.addBeforePreceding(this.getPreceding());
        this.removePreceding();
        HiddenTokenAwareTree last = children.get(children.size() - 1);
        last.addFollowing(this.getFollowing());
        this.removeFollowing();
    }

    public void giveHidden(HiddenTokenAwareTree previous, HiddenTokenAwareTree next) {
        if (previous != null) {
            previous.addFollowing(this.getPreceding());
        }
        if (next != null) {
            next.addBeforePreceding(this.getFollowing());
        }
    }

    public void moveHidden(HiddenTokenAwareTree previous, HiddenTokenAwareTree next) {
        if (previous != null) {
            previous.addFollowing(this.getPreceding());
            this.preceding = new LinkedList<CommonToken>();
        }
        if (next != null) {
            next.addBeforePreceding(this.getFollowing());
            this.following = new LinkedList<CommonToken>();
        }
    }

    public HiddenTokenAwareTree getLastChild() {
        return this.getChild(this.getChildCount() - 1);
    }

    public int getLine() {
        if (!this.isReal()) {
            HiddenTokenAwareTree realChild = this.getFirstRealDescendant();
            if (realChild != null) {
                return realChild.getLine();
            }
            return 0;
        }
        return this.token.getLine();
    }

    public int getColumn() {
        if (!this.isReal()) {
            HiddenTokenAwareTree realChild = this.getFirstRealDescendant();
            if (realChild != null) {
                return realChild.getCharPositionInLine();
            }
            return 0;
        }
        return this.token.getCharPositionInLine();
    }

    private HiddenTokenAwareTree getFirstRealDescendant() {
        for (HiddenTokenAwareTree child : this.getChildren()) {
            if (child.isReal()) {
                return child;
            }
            HiddenTokenAwareTree descendant = child.getFirstRealDescendant();
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    public int getCharPositionInLine() {
        if (!this.isReal()) {
            HiddenTokenAwareTree realChild = this.getFirstRealDescendant();
            if (realChild != null) {
                return realChild.getCharPositionInLine();
            }
            return 1;
        }
        return this.token.getCharPositionInLine();
    }

    public String toString() {
        return super.toString() + " " + this.getLine() + ":" + this.getCharPositionInLine() + 1;
    }

    public HiddenTokenAwareTree getNextSibling() {
        if (this.getParent() == null) {
            return null;
        }
        List<HiddenTokenAwareTree> siblings = this.getParent().getChildren();
        int indx = siblings.indexOf(this) + 1;
        return indx >= siblings.size() ? null : siblings.get(indx);
    }

    public HiddenTokenAwareTree getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        List<HiddenTokenAwareTree> siblings = this.getParent().getChildren();
        int indx = siblings.indexOf(this) - 1;
        return indx < 0 ? null : siblings.get(indx);
    }

    public void pushHiddenToSiblings() {
        HiddenTokenAwareTree nextSibling;
        HiddenTokenAwareTree previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            previousSibling.addFollowing(this.getPreceding());
            this.getPreceding().clear();
        }
        if ((nextSibling = this.getNextSibling()) != null) {
            nextSibling.addBeforePreceding(this.getFollowing());
            this.getFollowing().clear();
        }
    }

    public void removePreceding() {
        this.preceding = new ArrayList<CommonToken>();
    }

    public void removeFollowing() {
        this.following = new ArrayList<CommonToken>();
    }

    public boolean isReal() {
        return this.tokenAsCommon != null && this.tokenAsCommon.getTokenIndex() != -1;
    }

    public HiddenTokenAwareTree commentsLessClone() {
        try {
            HiddenTokenAwareTree clone = (HiddenTokenAwareTree)super.clone();
            clone.preceding = new LinkedList<CommonToken>();
            clone.orphans = new LinkedList<CommonToken>();
            clone.following = new LinkedList<CommonToken>();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

