/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public final class QuartzSchedulerUtils {
    private QuartzSchedulerUtils() {
    }

    public static Scheduler getScheduler(String id, boolean startSchedulerWhenNotStarted) throws SchedulerException {
        String schedName = id + ".scheduler";
        Scheduler scheduler = new StdSchedulerFactory().getScheduler(schedName);
        if (scheduler == null) {
            String quartzConfigurationFile = "quartz-" + id + ".properties";
            try (InputStream in = QuartzSchedulerUtils.class.getClassLoader().getResourceAsStream(quartzConfigurationFile);){
                if (in == null) {
                    scheduler = StdSchedulerFactory.getDefaultScheduler();
                } else {
                    Properties configuration = new Properties();
                    configuration.load(in);
                    configuration.put("org.quartz.scheduler.instanceName", schedName);
                    StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
                    stdSchedulerFactory.initialize(configuration);
                    scheduler = stdSchedulerFactory.getScheduler();
                }
            }
            catch (IOException e) {
                throw new SchedulerException("Unable to load configuration for scheduler " + id + ".  Configuration file " + quartzConfigurationFile + " exists and was loaded but an error occurred during loading", (Throwable)e);
            }
        }
        if (startSchedulerWhenNotStarted && !scheduler.isStarted()) {
            scheduler.start();
        }
        return scheduler;
    }

    public static Trigger getTrigger(String id, String groupName, String schedule, long maxEvery, TimeZone tz) {
        TriggerBuilder trigger = TriggerBuilder.newTrigger().withIdentity(id, groupName);
        try {
            CronScheduleBuilder schedulerBuilder = CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression(schedule));
            schedulerBuilder.inTimeZone(tz);
            trigger.withSchedule((ScheduleBuilder)schedulerBuilder);
        }
        catch (ParseException e) {
            int periodMillis = 0;
            try {
                int everyMin = Integer.parseInt(schedule);
                periodMillis = everyMin * 1000 * 60;
            }
            catch (NumberFormatException nfe) {
                int mult = 0;
                StringTokenizer st = new StringTokenizer(schedule, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim().toLowerCase();
                    if (token.endsWith(" hour")) {
                        token = token.substring(0, token.length() - 5);
                        mult = 3600;
                    } else if (token.endsWith(" hours")) {
                        token = token.substring(0, token.length() - 6);
                        mult = 3600;
                    } else if (token.endsWith(" min")) {
                        token = token.substring(0, token.length() - 4);
                        mult = 60;
                    } else if (token.endsWith(" sec")) {
                        token = token.substring(0, token.length() - 4);
                        mult = 1;
                    } else {
                        throw new IllegalArgumentException("Bad period format :" + schedule);
                    }
                    periodMillis += mult * Integer.parseInt(token);
                }
            }
            if (periodMillis < 1 || (long)periodMillis > maxEvery) {
                throw new IllegalArgumentException(schedule + " is an illegal value, it must be between 1 and " + maxEvery);
            }
            trigger.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)periodMillis).repeatForever().withMisfireHandlingInstructionFireNow()).startAt(DateBuilder.futureDate((int)periodMillis, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND));
        }
        return trigger.build();
    }
}

