/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.fao.geonet.utils.IO;

class FileSystemSpecificStreamHandler
extends URLStreamHandler {
    FileSystemSpecificStreamHandler() {
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        try {
            final Path path = IO.toPath(new URI(u.toExternalForm().replace('\\', '/')));
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return IO.newInputStream(path);
                }

                @Override
                public int getContentLength() {
                    try {
                        long size = Files.size(path);
                        if (size > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)(path + " size is too large for the getContentLength method.  It is greater than Integer.MAX_VALUE: " + size));
                        }
                        return (int)size;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String getContentType() {
                    try {
                        return Files.probeContentType(path);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public long getLastModified() {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return Files.newOutputStream(path, new OpenOption[0]);
                }
            };
        }
        catch (URISyntaxException e1) {
            throw new Error(e1);
        }
    }
}

