/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.xml.reader;

import java.util.Vector;
import org.dlib.xml.XmlAttribute;
import org.dlib.xml.XmlCodec;
import org.dlib.xml.XmlElement;
import org.dlib.xml.XmlException;

class XmlTag {
    private static final String IDENTIFIER = "[a-zA-Z_\\-\\?][\\w\\-]*";
    private static final int STARTING_TAG = 0;
    private static final int ENDING_TAG = 1;
    private static final int FULL_TAG = 2;
    private String sName;
    private String sValue = "";
    private int iTagType;
    private Vector vAttribs = new Vector();
    private Vector vChildren = new Vector();

    public XmlTag(String string) throws XmlException {
        boolean bl = string.startsWith("/");
        boolean bl2 = string.endsWith("/");
        if (bl && bl2) {
            throw new XmlException("Not a starting/ending tag --> " + string);
        }
        if (!bl && !bl2) {
            this.iTagType = 0;
        } else if (bl && !bl2) {
            this.iTagType = 1;
            string = string.substring(1);
        } else {
            this.iTagType = 2;
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        int n = string.indexOf(" ");
        if (n != -1) {
            String string2 = string.substring(n + 1).trim();
            if (this.iTagType == 1) {
                throw new XmlException("Attributes go only in the starting tag");
            }
            this.handleAttribs(string2);
            string = string.substring(0, n);
        }
        if (!string.matches(IDENTIFIER)) {
            throw new XmlException("Tag name is not valid --> " + string);
        }
        this.sName = string;
    }

    public String getName() {
        return this.sName;
    }

    public boolean isStartingTag() {
        return this.iTagType == 0;
    }

    public boolean isEndingTag() {
        return this.iTagType == 1;
    }

    public boolean isFullTag() {
        return this.iTagType == 2;
    }

    public void setValue(String string) {
        this.sValue = string;
    }

    public XmlElement getXmlElement() {
        Object object;
        int n;
        XmlElement xmlElement = new XmlElement(this.sName);
        for (n = 0; n < this.vAttribs.size(); ++n) {
            object = (XmlAttribute)this.vAttribs.elementAt(n);
            xmlElement.setAttribute((XmlAttribute)object);
        }
        for (n = 0; n < this.vChildren.size(); ++n) {
            object = (XmlElement)this.vChildren.elementAt(n);
            xmlElement.addChild((XmlElement)object);
        }
        xmlElement.setValue(this.sValue);
        return xmlElement;
    }

    public void addChild(XmlElement xmlElement) {
        this.vChildren.addElement(xmlElement);
    }

    public String toString() {
        String string = "[Name:" + this.sName + ", Type:" + this.iTagType + ", Attribs:\n";
        for (int i = 0; i < this.vAttribs.size(); ++i) {
            string = string + this.vAttribs.elementAt(i) + "\n";
        }
        return string + "]";
    }

    private void handleAttribs(String string) throws XmlException {
        while (true) {
            String string2 = string;
            int n = string.indexOf("=");
            if (n == -1) {
                throw new XmlException("Invalid attribute syntax --> " + string2);
            }
            String string3 = string.substring(0, n).trim();
            if (!string3.matches(IDENTIFIER)) {
                throw new XmlException("Attribute name is not valid --> " + string3);
            }
            if (!(string = string.substring(n + 1).trim()).startsWith("\"")) {
                throw new XmlException("Attribute value must start with a '\"' --> " + string2);
            }
            int n2 = (string = string.substring(1)).indexOf("\"");
            if (n2 == -1) {
                throw new XmlException("Attribute value must end with a '\"' --> " + string2);
            }
            String string4 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            this.vAttribs.addElement(new XmlAttribute(string3, XmlCodec.decode(string4)));
            if (string.equals("")) {
                return;
            }
            if (!string.substring(0, 1).matches("\\s+")) {
                throw new XmlException("Attributes must be separated by a white space --> " + string2);
            }
            string = string.trim();
        }
    }
}

