/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Keymap;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlToolkit {
    private Hashtable htActions = new Hashtable();
    private JEditorPane jep;
    private HTMLDocument htmlDoc;
    private HTMLEditorKit htmlKit;
    public static final int STYLE_BOLD = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_UNDERLINE = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final String FONT_SANS_SERIF = "SansSerif";
    public static final String FONT_MONOSPACED = "Monospaced";

    HtmlToolkit(JEditorPane jEditorPane) {
        this.jep = jEditorPane;
        this.jep.setContentType("text/html");
        this.htmlDoc = (HTMLDocument)this.jep.getDocument();
        this.htmlKit = (HTMLEditorKit)this.jep.getEditorKit();
        StyleSheet styleSheet = this.htmlDoc.getStyleSheet();
        styleSheet.addRule("body { font-family: sans-serif, default; font-size: 12pt; white-space: pre }");
        this.initActionTable();
        this.initKeyBindings();
    }

    public void requestFocus() {
        this.jep.requestFocus();
    }

    public void setText(String string) {
        this.jep.setText(string);
    }

    public String getText() {
        return this.jep.getText();
    }

    public void replaceSelection(String string) {
        this.jep.replaceSelection(string);
    }

    public HTMLDocument getDocument() {
        return this.htmlDoc;
    }

    public JEditorPane getEditorPane() {
        return this.jep;
    }

    public Element getParagraph() {
        return this.htmlDoc.getParagraphElement(this.pos());
    }

    public Element getRootElement() {
        return this.htmlDoc.getDefaultRootElement();
    }

    public int getCaretPosition() {
        return this.pos();
    }

    public String getWordAt(int n) {
        try {
            int n2 = this.getWordStart(n);
            int n3 = this.getWordEnd(n);
            if (n2 == n3) {
                return null;
            }
            return this.htmlDoc.getText(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public int getWordStart(int n) {
        while (n > 0 && !this.isWhiteSpaceAt(n - 1)) {
            --n;
        }
        return n;
    }

    public int getWordEnd(int n) {
        while (n < this.htmlDoc.getLength() && !this.isWhiteSpaceAt(n)) {
            ++n;
        }
        return n;
    }

    public boolean isWordAt(int n) {
        return !this.isWhiteSpaceAt(n);
    }

    public boolean isSelectionSet() {
        return this.jep.getSelectionStart() != this.jep.getSelectionEnd();
    }

    public void selectWord() {
        int n = this.getWordStart(this.pos());
        int n2 = this.getWordEnd(this.pos());
        this.jep.setSelectionStart(n);
        this.jep.setSelectionEnd(n2);
    }

    public void setFontStyle(int n) {
        if (n == 0) {
            this.invoke("font-bold");
        }
        if (n == 1) {
            this.invoke("font-italic");
        }
        if (n == 2) {
            this.invoke("font-underline");
        }
    }

    public void setFontColor(Color color) {
        this.invoke(new StyledEditorKit.ForegroundAction("", color), "");
    }

    public void setFontSize(int n) {
        this.invoke(new StyledEditorKit.FontSizeAction("", n));
    }

    public void setFontName(String string) {
        this.invoke(new StyledEditorKit.FontFamilyAction("", string));
    }

    public Font getFont() {
        return this.htmlDoc.getFont(this.htmlDoc.getCharacterElement(this.pos()).getAttributes());
    }

    public void setAlignment(int n) {
        this.invoke(new StyledEditorKit.AlignmentAction("", n));
    }

    public Element getElementAt(int n) {
        return this.htmlDoc.getCharacterElement(n);
    }

    public boolean isWhiteSpaceAt(int n) {
        try {
            String string = this.htmlDoc.getText(n, 1);
            return string.equals(" ") || string.equals("\n") || string.equals("\t");
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return false;
        }
    }

    public void insertOrderedItem() {
        this.insertListItem(HTML.Tag.OL);
    }

    public void insertUnorderedItem() {
        this.insertListItem(HTML.Tag.UL);
    }

    public void insertImage(String string) {
        int n = this.pos();
        Element element = this.getElementAt(n);
        if (element.getStartOffset() + 1 == element.getEndOffset()) {
            n = element.getEndOffset();
        }
        try {
            String string2 = "<img align=bottom border=1 src=\"file:" + string + "\"></img>";
            this.htmlKit.insertHTML(this.htmlDoc, this.pos(), string2, 0, 0, HTML.Tag.IMG);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insertAnchor(final String string) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string3 = HtmlToolkit.this.jep.getSelectedText();
                    HtmlToolkit.this.htmlDoc.remove(HtmlToolkit.this.jep.getSelectionStart(), string3.length());
                    String string2 = "<" + HTML.Tag.A + " href=\"" + string + "\">" + string3 + "</" + HTML.Tag.A + ">";
                    HtmlToolkit.this.htmlKit.insertHTML(HtmlToolkit.this.htmlDoc, HtmlToolkit.this.pos(), string2, 0, 0, HTML.Tag.A);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.invoke(abstractAction);
    }

    private void initActionTable() {
        Action[] actionArray = this.jep.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            this.htActions.put(actionArray[i].getValue("Name"), actionArray[i]);
        }
    }

    private void initKeyBindings() {
        Keymap keymap = JEditorPane.addKeymap("HtmlToolkit", this.jep.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(66, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HtmlToolkit.this.setFontStyle(0);
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(73, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HtmlToolkit.this.setFontStyle(1);
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(85, 2), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HtmlToolkit.this.setFontStyle(2);
            }
        });
        this.jep.setKeymap(keymap);
    }

    private int pos() {
        return this.jep.getCaretPosition();
    }

    private void invoke(String string) {
        this.invoke(this.getActionByName(string), null);
    }

    private void invoke(Action action) {
        this.invoke(action, null);
    }

    private void invoke(Action action, String string) {
        ActionEvent actionEvent = new ActionEvent(this.jep, 0, string);
        if (this.isSelectionSet()) {
            action.actionPerformed(actionEvent);
        } else {
            int n = this.pos();
            this.selectWord();
            action.actionPerformed(actionEvent);
            this.jep.setCaretPosition(n);
        }
    }

    private Action getActionByName(String string) {
        return (Action)this.htActions.get(string);
    }

    private void insertListItem(HTML.Tag tag) {
        String string = tag.toString();
        String string2 = "<" + string + "><li></li></" + string + ">";
        try {
            Element element = this.getParagraph();
            int n = element.getEndOffset() - 1;
            Element element2 = this.getParagraph().getParentElement();
            if (element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.LI) {
                this.htmlKit.insertHTML(this.htmlDoc, n, string2, 1, 0, tag);
                this.jep.setCaretPosition(this.pos() - 1);
            } else if (element.getStartOffset() == n) {
                this.htmlKit.insertHTML(this.htmlDoc, n, "<p></p>", 3, 0, HTML.Tag.P);
                this.htmlDoc.remove(n + 1, 1);
                this.jep.setCaretPosition(n);
            } else {
                this.htmlKit.insertHTML(this.htmlDoc, n, "<li></li>", 2, 0, HTML.Tag.LI);
                this.htmlDoc.remove(n + 2, 1);
                this.jep.setCaretPosition(n + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

