/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui;

import java.awt.Graphics;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import org.dlib.gui.CustomLook;
import org.dlib.gui.TComboRenderer;

public class TComboBox
extends JComboBox {
    private Vector vImages = new Vector();
    private Vector vKeys = new Vector();

    public TComboBox() {
        this.setRenderer(new TComboRenderer(this));
        this.setPreferredSize(CustomLook.comboSize);
        this.setBackground(CustomLook.comboColor);
        this.setFont(CustomLook.comboFont);
    }

    public void addItem() {
    }

    public void addItem(String string, Object object) {
        this.addItem(null, string, object);
    }

    public void addItem(int n, Object object) {
        this.addItem(null, Integer.toString(n), object);
    }

    public void addItem(Icon icon, String string, Object object) {
        this.vImages.addElement(icon);
        this.vKeys.addElement(string);
        if (object == null) {
            object = "       " + string;
        }
        this.addItem(object);
    }

    public void addItem(Icon icon, int n, Object object) {
        this.addItem(icon, Integer.toString(n), object);
    }

    public String getKeyAt(int n) {
        return (String)this.vKeys.elementAt(n);
    }

    public int getIntKeyAt(int n) {
        return Integer.parseInt(this.getKeyAt(n));
    }

    public String getSelectedKey() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (String)this.vKeys.elementAt(n);
    }

    public int getSelectedIntKey() {
        return Integer.parseInt(this.getSelectedKey());
    }

    public Icon getItemIcon(int n) {
        if (n == -1) {
            return null;
        }
        return (Icon)this.vImages.elementAt(n);
    }

    public void insertItemAt(String string, Object object, int n) {
        this.insertItemAt(null, string, object, n);
    }

    public void insertItemAt(Icon icon, String string, Object object, int n) {
        this.vImages.insertElementAt(icon, n);
        this.vKeys.insertElementAt(string, n);
        this.insertItemAt(object, n);
    }

    public void insertItemAt(Icon icon, int n, Object object, int n2) {
        this.insertItemAt(icon, "" + n, object, n2);
    }

    public void removeAllItems() {
        this.vImages.removeAllElements();
        this.vKeys.removeAllElements();
        super.removeAllItems();
    }

    public void removeItemAt(int n) {
        this.vImages.removeElementAt(n);
        this.vKeys.removeElementAt(n);
        super.removeItemAt(n);
    }

    public void setSelectedKey(String string) {
        int n = this.vKeys.indexOf(string);
        if (n == -1) {
            return;
        }
        this.setSelectedIndex(n);
    }

    public void setSelectedKey(int n) {
        this.setSelectedKey("" + n);
    }

    public Object getItemFromKey(String string) {
        int n = this.vKeys.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("Key not found:" + string);
        }
        return this.getItemAt(n);
    }

    public Object getItemFromKey(int n) {
        return this.getItemFromKey("" + n);
    }

    public void paintComponent(Graphics graphics) {
        CustomLook.setup(graphics);
        super.paintComponent(graphics);
    }
}

