/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.compensating.support;

import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;
import org.springframework.transaction.compensating.CompensatingTransactionOperationFactory;
import org.springframework.transaction.compensating.CompensatingTransactionOperationManager;
import org.springframework.transaction.compensating.CompensatingTransactionOperationRecorder;

public class DefaultCompensatingTransactionOperationManager
implements CompensatingTransactionOperationManager {
    private static Log log = LogFactory.getLog((Class)DefaultCompensatingTransactionOperationManager.class);
    private Stack operationExecutors = new Stack();
    private CompensatingTransactionOperationFactory operationFactory;

    public DefaultCompensatingTransactionOperationManager(CompensatingTransactionOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    public void performOperation(Object resource, String operation, Object[] args) {
        CompensatingTransactionOperationRecorder recorder = this.operationFactory.createRecordingOperation(resource, operation);
        CompensatingTransactionOperationExecutor executor = recorder.recordOperation(args);
        executor.performOperation();
        this.operationExecutors.push(executor);
    }

    public void rollback() {
        log.debug((Object)"Performing rollback");
        while (!this.operationExecutors.isEmpty()) {
            CompensatingTransactionOperationExecutor rollbackOperation = (CompensatingTransactionOperationExecutor)this.operationExecutors.pop();
            try {
                rollbackOperation.rollback();
            }
            catch (Exception e) {
                throw new TransactionSystemException("Error occurred during rollback", (Throwable)e);
            }
        }
    }

    protected Stack getOperationExecutors() {
        return this.operationExecutors;
    }

    void setOperationExecutors(Stack operationExecutors) {
        this.operationExecutors = operationExecutors;
    }

    public void commit() {
        log.debug((Object)"Performing commit");
        Iterator iter = this.operationExecutors.iterator();
        while (iter.hasNext()) {
            CompensatingTransactionOperationExecutor operationExecutor = (CompensatingTransactionOperationExecutor)iter.next();
            try {
                operationExecutor.commit();
            }
            catch (Exception e) {
                throw new TransactionSystemException("Error occurred during commit", (Throwable)e);
            }
        }
    }
}

