/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.LongHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class LongOpenHashSet
extends AbstractLongSet
implements LongSet,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private LongHashFunction keyhash;
    private int size;
    private transient long[] data;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;

    private LongOpenHashSet(LongHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.data = new long[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private LongOpenHashSet(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultLongHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public LongOpenHashSet() {
        this(11);
    }

    public LongOpenHashSet(LongCollection c) {
        this();
        this.addAll(c);
    }

    public LongOpenHashSet(long[] a) {
        this();
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    public LongOpenHashSet(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public LongOpenHashSet(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public LongOpenHashSet(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public LongOpenHashSet(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongOpenHashSet(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public LongOpenHashSet(LongHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public LongOpenHashSet(LongHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public LongOpenHashSet(LongHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public LongOpenHashSet(LongHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public LongOpenHashSet(LongHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongOpenHashSet(LongHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            long[] newdata = new long[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.data.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    long v = this.data[i];
                    int h = Math.abs(this.keyhash.hash(v));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newdata[n] = v;
                }
                ++i;
            }
            this.data = newdata;
            this.states = newstates;
        }
    }

    public boolean add(long v) {
        int i;
        block5: {
            this.ensureCapacity(this.used + 1);
            int h = Math.abs(this.keyhash.hash(v));
            i = h % this.data.length;
            if (this.states[i] == 1) {
                if (this.data[i] == v) {
                    return false;
                }
                int c = 1 + h % (this.data.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.data.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.data[i] != v);
                return false;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.data[i] = v;
        ++this.size;
        return true;
    }

    public LongIterator iterator() {
        return new LongIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < LongOpenHashSet.this.data.length && LongOpenHashSet.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < LongOpenHashSet.this.data.length;
            }

            public long next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
                return LongOpenHashSet.this.data[this.lastEntry];
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((LongOpenHashSet)LongOpenHashSet.this).states[this.lastEntry] = 2;
                LongOpenHashSet.this.size--;
                this.lastEntry = -1;
            }
        };
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            LongOpenHashSet c = (LongOpenHashSet)super.clone();
            c.data = new long[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            c.states = new byte[this.data.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.used = 0;
        Arrays.fill(this.states, (byte)0);
    }

    public boolean contains(long v) {
        int h = Math.abs(this.keyhash.hash(v));
        int i = h % this.data.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.data[i] == v) {
                return true;
            }
            int c = 1 + h % (this.data.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.data.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.data[i] != v);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.states[i] == 1) {
                h = (int)((long)h + this.data[i]);
            }
            ++i;
        }
        return h;
    }

    public boolean remove(long v) {
        int h = Math.abs(this.keyhash.hash(v));
        int i = h % this.data.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.data[i] == v) {
                this.states[i] = 2;
                --this.size;
                return true;
            }
            int c = 1 + h % (this.data.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.data.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.data[i] != v);
            this.states[i] = 2;
            --this.size;
            return true;
        }
        return false;
    }

    public long[] toArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        int p = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.states[i] == 1) {
                a[p++] = this.data[i];
            }
            ++i;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            long x = i.next();
            s.writeLong(x);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new long[s.readInt()];
        this.states = new byte[this.data.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            long v = s.readLong();
            int h = Math.abs(this.keyhash.hash(v));
            int i = h % this.data.length;
            if (this.states[i] == 1) {
                int c = 1 + h % (this.data.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.data.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.data[i] = v;
            ++n;
        }
    }
}

