/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.IntCollection;
import bak.pcj.IntIterator;
import bak.pcj.set.AbstractIntSet;
import bak.pcj.set.IntRange;
import bak.pcj.set.IntSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

public class IntRangeSet
extends AbstractIntSet
implements IntSortedSet,
Cloneable,
Serializable {
    private ArrayList ranges = new ArrayList();
    private int size = 0;

    public IntRangeSet() {
    }

    public IntRangeSet(int[] a) {
        this();
        this.addAll(a);
    }

    public IntRangeSet(IntCollection c) {
        this();
        this.addAll(c);
    }

    private IntRange range(int index) {
        return (IntRange)this.ranges.get(index);
    }

    private IntRange getRangeOf(int v) {
        int index = this.getRangeIndexOf(v);
        return index >= 0 ? this.range(index) : null;
    }

    private int getRangeIndexOf(int v) {
        if (this.size == 0) {
            return -1;
        }
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            IntRange r = (IntRange)this.ranges.get(mid);
            if (r.contains(v)) {
                return mid;
            }
            if (v < r.first()) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    private int insertRange(IntRange range) {
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            IntRange r = this.range(mid);
            int compare = range.compareTo(r);
            if (compare == 0) {
                return -1;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        this.ranges.add(lo, range);
        return lo;
    }

    private void normalize(int index) {
        while (index < this.ranges.size() - 1) {
            IntRange r2;
            IntRange r1 = this.range(index);
            IntRange r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 == null) break;
            this.ranges.set(index, r3);
            this.ranges.remove(index + 1);
            this.size -= r1.intersectionLength(r2);
        }
    }

    private void normalize() {
        IntRange r3;
        int index = 0;
        this.size = 0;
        while (index < this.ranges.size() - 1) {
            IntRange r2;
            IntRange r1 = this.range(index);
            r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 != null) {
                this.ranges.set(index, r3);
                this.ranges.remove(index + 1);
                continue;
            }
            this.size += r1.length();
            ++index;
        }
        r3 = this.range(this.ranges.size() - 1);
        this.size += r3.length();
    }

    public boolean add(int v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return false;
        }
        int insertionIndex = -index - 1;
        this.ranges.add(insertionIndex, new IntRange(v, v));
        if (insertionIndex > 0) {
            --insertionIndex;
        }
        ++this.size;
        this.normalize(insertionIndex);
        return true;
    }

    public IntIterator iterator() {
        return new IntIterator(){
            int nextIndex = 0;
            int lastIndex = -1;
            int currRange = 0;
            int currOffset = 0;
            int lastValue;

            public boolean hasNext() {
                return this.nextIndex < IntRangeSet.this.size;
            }

            public int next() {
                if (this.nextIndex >= IntRangeSet.this.size) {
                    Exceptions.endOfIterator();
                }
                this.lastIndex = this.nextIndex++;
                this.lastValue = this.curr();
                if (this.nextIndex < IntRangeSet.this.size) {
                    if (this.currOffset == IntRangeSet.this.range(this.currRange).length() - 1) {
                        ++this.currRange;
                        this.currOffset = 0;
                    } else {
                        ++this.currOffset;
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                IntRangeSet.this.remove(this.lastValue);
                --this.nextIndex;
                if (this.nextIndex < IntRangeSet.this.size) {
                    this.recalc();
                }
                this.lastIndex = -1;
            }

            private int curr() {
                return IntRangeSet.this.range(this.currRange).first() + this.currOffset;
            }

            private void recalc() {
                int rs;
                this.currRange = 0;
                this.currOffset = this.nextIndex;
                while (this.currOffset >= (rs = IntRangeSet.this.range(this.currRange).length())) {
                    this.currOffset -= rs;
                    ++this.currRange;
                }
            }
        };
    }

    public int first() {
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        return this.range(0).first();
    }

    private int firstFrom(int v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        if ((index = -index - 1) >= this.ranges.size()) {
            Exceptions.setNoFirst();
        }
        return this.range(index).first();
    }

    public int last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        return this.range(this.ranges.size() - 1).last();
    }

    private int lastFrom(int v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        index = -index - 1;
        if (--index < 0 || index >= this.ranges.size()) {
            Exceptions.setNoLast();
        }
        return this.range(index).last();
    }

    public IntSortedSet headSet(int to) {
        return new SubSet(false, 0, true, to);
    }

    public IntSortedSet tailSet(int from) {
        return new SubSet(true, from, false, 0);
    }

    public IntSortedSet subSet(int from, int to) {
        return new SubSet(true, from, true, to);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        int i = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.range(i));
            ++i;
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            IntRangeSet c = (IntRangeSet)super.clone();
            c.ranges = (ArrayList)this.ranges.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        this.ranges.clear();
        this.size = 0;
    }

    public boolean contains(int v) {
        return this.getRangeIndexOf(v) >= 0;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        boolean index = false;
        int rsize = this.ranges.size();
        while (i < rsize) {
            IntRange r = this.range(i);
            int c = r.first();
            int last = r.last();
            while (c <= last) {
                h += c;
                ++c;
            }
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(int v) {
        int index = this.getRangeIndexOf(v);
        if (index < 0) {
            return false;
        }
        IntRange r = this.range(index);
        if (v == r.first()) {
            if (r.length() == 1) {
                this.ranges.remove(index);
            } else {
                this.ranges.set(index, new IntRange(r.first() + 1, r.last()));
            }
        } else if (v == r.last()) {
            this.ranges.set(index, new IntRange(r.first(), r.last() - 1));
        } else {
            IntRange r1 = new IntRange(r.first(), v - 1);
            IntRange r2 = new IntRange(v + 1, r.last());
            this.ranges.set(index, r1);
            this.ranges.add(index + 1, r2);
        }
        --this.size;
        return true;
    }

    public int[] toArray(int[] a) {
        if (a == null || a.length < this.size) {
            a = new int[this.size];
        }
        int i = 0;
        int index = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            IntRange r = this.range(i);
            int c = r.first();
            int last = r.last();
            while (c <= last) {
                a[index++] = c++;
            }
            ++i;
        }
        return a;
    }

    public boolean containsAll(IntRange range) {
        IntRange r = this.getRangeOf(range.first());
        return r != null ? r.contains(range.last()) : false;
    }

    public boolean addAll(IntRangeSet c) {
        int oldSize = this.size;
        int i = 0;
        int rsize = c.ranges.size();
        while (i < rsize) {
            this.addAll(c.range(i));
            ++i;
        }
        return this.size != oldSize;
    }

    public boolean addAll(IntRange range) {
        int oldSize = this.size;
        int index = this.insertRange(range);
        if (index != -1) {
            int nindex = index;
            if (nindex > 0) {
                --nindex;
            }
            this.size += range.length();
            this.normalize(nindex);
        }
        return this.size != oldSize;
    }

    public boolean addAll(int first, int last) {
        return this.addAll(new IntRange(first, last));
    }

    public boolean addAll(int[] a) {
        int[] sa;
        if (a.length == 0) {
            return false;
        }
        int oldSize = this.size;
        if (!this.isSorted(a)) {
            sa = (int[])a.clone();
            Arrays.sort(sa);
        } else {
            sa = a;
        }
        int index = 0;
        while (index < sa.length) {
            int c0 = sa[index];
            index = this.range(sa, index);
            int c1 = sa[index];
            this.ranges.add(new IntRange(c0, c1));
            ++index;
        }
        Collections.sort(this.ranges);
        this.normalize();
        return this.size != oldSize;
    }

    private int range(int[] a, int index) {
        int c0 = a[index++];
        while (index < a.length && a[index] == c0) {
            ++index;
        }
        while (index < a.length && a[index] == c0 + 1) {
            c0 = a[index++];
            while (index < a.length && a[index] == c0) {
                ++index;
            }
        }
        return index - 1;
    }

    private boolean isSorted(int[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IntRange[] ranges() {
        IntRange[] a = new IntRange[this.ranges.size()];
        this.ranges.toArray(a);
        return a;
    }

    private class SubSet
    extends AbstractIntSet
    implements IntSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private int lowerBound;
        private int upperBound;

        SubSet(boolean hasLowerBound, int lowerBound, boolean hasUpperBound, int upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(int v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return IntRangeSet.this.add(v);
        }

        public boolean remove(int v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return IntRangeSet.this.remove(v);
        }

        public boolean contains(int v) {
            return this.inSubRange(v) && IntRangeSet.this.contains(v);
        }

        public IntIterator iterator() {
            int first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e) {
                return new EmptySubSetIterator();
            }
            int last = this.last();
            int rangeIndexLow = IntRangeSet.this.getRangeIndexOf(first);
            int rangeIndexHigh = IntRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                return new SimpleSubSetIterator(first, last);
            }
            return new NonEmptySubSetIterator(first, last, rangeIndexLow, rangeIndexHigh);
        }

        public int size() {
            int size;
            int rangeIndexLow;
            int first;
            if (IntRangeSet.this.size() == 0) {
                return 0;
            }
            try {
                first = this.first();
                rangeIndexLow = IntRangeSet.this.getRangeIndexOf(first);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            int last = this.last();
            int rangeIndexHigh = IntRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                size = last - first + 1;
            } else {
                IntRange rangeLow = IntRangeSet.this.range(rangeIndexLow);
                IntRange rangeHigh = IntRangeSet.this.range(rangeIndexHigh);
                int sizeLow = rangeLow.last() - first + 1;
                int sizeHigh = last - rangeHigh.first() + 1;
                size = sizeLow + sizeHigh;
                int i = rangeIndexLow + 1;
                while (i < rangeIndexHigh) {
                    size += IntRangeSet.this.range(i).length();
                    ++i;
                }
            }
            return size;
        }

        public int first() {
            int first = IntRangeSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : 0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public int last() {
            int last = IntRangeSet.this.lastFrom(this.hasUpperBound ? this.upperBound - 1 : IntRangeSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public IntSortedSet headSet(int to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public IntSortedSet tailSet(int from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public IntSortedSet subSet(int from, int to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(int v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class NonEmptySubSetIterator
        implements IntIterator {
            int first;
            int last;
            int rangeIndexLow;
            int rangeIndexHigh;
            IntRange rangeLow;
            IntRange rangeHigh;
            int previousValue;
            IntRange currRange;
            int currRangeIndex;
            int currOffset;
            boolean valueAvailable;
            int nextIndex;

            NonEmptySubSetIterator(int first, int last, int rangeIndexLow, int rangeIndexHigh) {
                if (rangeIndexLow == rangeIndexHigh) {
                    throw new RuntimeException("Internal error");
                }
                this.first = first;
                this.last = last;
                this.rangeIndexLow = rangeIndexLow;
                this.rangeIndexHigh = rangeIndexHigh;
                this.rangeLow = new IntRange(first, IntRangeSet.this.range(rangeIndexLow).last());
                this.rangeHigh = new IntRange(IntRangeSet.this.range(rangeIndexHigh).first(), last);
                this.currRangeIndex = rangeIndexLow;
                this.currRange = this.rangeLow;
                this.currOffset = 0;
                this.previousValue = first;
                this.valueAvailable = false;
                this.nextIndex = 0;
            }

            private IntRange getRange(int rangeIndex) {
                if (rangeIndex == this.rangeIndexLow) {
                    return this.rangeLow;
                }
                if (rangeIndex == this.rangeIndexHigh) {
                    return this.rangeHigh;
                }
                return IntRangeSet.this.range(rangeIndex);
            }

            private void recalc() {
                int rs;
                this.first = SubSet.this.first();
                this.last = SubSet.this.last();
                this.rangeIndexLow = IntRangeSet.this.getRangeIndexOf(this.first);
                this.rangeIndexHigh = IntRangeSet.this.getRangeIndexOf(this.last);
                if (this.rangeIndexLow == this.rangeIndexHigh) {
                    this.rangeLow = this.rangeHigh = new IntRange(this.first, this.last);
                } else {
                    this.rangeLow = new IntRange(this.first, IntRangeSet.this.range(this.rangeIndexLow).last());
                    this.rangeHigh = new IntRange(IntRangeSet.this.range(this.rangeIndexHigh).first(), this.last);
                }
                this.currOffset = this.nextIndex;
                this.currRangeIndex = this.rangeIndexLow;
                this.currRange = this.rangeLow;
                while (this.currOffset >= (rs = this.currRange.length())) {
                    this.currOffset -= rs;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
            }

            public boolean hasNext() {
                return this.previousValue < this.last;
            }

            public int next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.previousValue = this.currRange.first() + this.currOffset++;
                if (this.currOffset == this.currRange.length() && this.previousValue < this.last) {
                    this.currOffset = 0;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
                ++this.nextIndex;
                this.valueAvailable = true;
                return this.previousValue;
            }

            public void remove() {
                if (!this.valueAvailable) {
                    Exceptions.noElementToRemove();
                }
                IntRangeSet.this.remove(this.previousValue);
                --this.nextIndex;
                this.recalc();
                this.valueAvailable = false;
            }
        }

        class SimpleSubSetIterator
        implements IntIterator {
            int nextIndex;
            int size;
            int lastIndex;
            int lastValue;
            int from;
            int to;

            SimpleSubSetIterator(int from, int to) {
                this.size = to - from + 1;
                this.nextIndex = 0;
                this.lastIndex = -1;
                this.from = from;
                this.to = to;
            }

            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            public int next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = this.from + this.nextIndex;
                this.lastIndex = this.nextIndex++;
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                IntRangeSet.this.remove(this.lastValue);
                this.lastIndex = -1;
            }
        }

        class EmptySubSetIterator
        implements IntIterator {
            EmptySubSetIterator() {
            }

            public boolean hasNext() {
                return false;
            }

            public int next() {
                Exceptions.endOfIterator();
                throw new RuntimeException();
            }

            public void remove() {
                Exceptions.noElementToRemove();
            }
        }
    }
}

