/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.CharCollection;
import bak.pcj.CharIterator;
import bak.pcj.set.AbstractCharSet;
import bak.pcj.set.CharRange;
import bak.pcj.set.CharSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;

public class CharRangeSet
extends AbstractCharSet
implements CharSortedSet,
Cloneable,
Serializable {
    private ArrayList ranges = new ArrayList();
    private int size = 0;

    public CharRangeSet() {
    }

    public CharRangeSet(char[] a) {
        this();
        this.addAll(a);
    }

    public CharRangeSet(CharCollection c) {
        this();
        this.addAll(c);
    }

    private CharRange range(int index) {
        return (CharRange)this.ranges.get(index);
    }

    private CharRange getRangeOf(char v) {
        int index = this.getRangeIndexOf(v);
        return index >= 0 ? this.range(index) : null;
    }

    private int getRangeIndexOf(char v) {
        if (this.size == 0) {
            return -1;
        }
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            CharRange r = (CharRange)this.ranges.get(mid);
            if (r.contains(v)) {
                return mid;
            }
            if (v < r.first()) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -(lo + 1);
    }

    private int insertRange(CharRange range) {
        int lo = 0;
        int hi = this.ranges.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            CharRange r = this.range(mid);
            int compare = range.compareTo(r);
            if (compare == 0) {
                return -1;
            }
            if (compare < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        this.ranges.add(lo, range);
        return lo;
    }

    private void normalize(int index) {
        while (index < this.ranges.size() - 1) {
            CharRange r2;
            CharRange r1 = this.range(index);
            CharRange r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 == null) break;
            this.ranges.set(index, r3);
            this.ranges.remove(index + 1);
            this.size -= r1.intersectionLength(r2);
        }
    }

    private void normalize() {
        CharRange r3;
        int index = 0;
        this.size = 0;
        while (index < this.ranges.size() - 1) {
            CharRange r2;
            CharRange r1 = this.range(index);
            r3 = r1.tryMergeWith(r2 = this.range(index + 1));
            if (r3 != null) {
                this.ranges.set(index, r3);
                this.ranges.remove(index + 1);
                continue;
            }
            this.size += r1.length();
            ++index;
        }
        r3 = this.range(this.ranges.size() - 1);
        this.size += r3.length();
    }

    public boolean add(char v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return false;
        }
        int insertionIndex = -index - 1;
        this.ranges.add(insertionIndex, new CharRange(v, v));
        if (insertionIndex > 0) {
            --insertionIndex;
        }
        ++this.size;
        this.normalize(insertionIndex);
        return true;
    }

    public CharIterator iterator() {
        return new CharIterator(){
            int nextIndex = 0;
            int lastIndex = -1;
            int currRange = 0;
            int currOffset = 0;
            char lastValue;

            public boolean hasNext() {
                return this.nextIndex < CharRangeSet.this.size;
            }

            public char next() {
                if (this.nextIndex >= CharRangeSet.this.size) {
                    Exceptions.endOfIterator();
                }
                this.lastIndex = this.nextIndex++;
                this.lastValue = this.curr();
                if (this.nextIndex < CharRangeSet.this.size) {
                    if (this.currOffset == CharRangeSet.this.range(this.currRange).length() - 1) {
                        ++this.currRange;
                        this.currOffset = 0;
                    } else {
                        ++this.currOffset;
                    }
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                CharRangeSet.this.remove(this.lastValue);
                --this.nextIndex;
                if (this.nextIndex < CharRangeSet.this.size) {
                    this.recalc();
                }
                this.lastIndex = -1;
            }

            private char curr() {
                return (char)(CharRangeSet.this.range(this.currRange).first() + this.currOffset);
            }

            private void recalc() {
                int rs;
                this.currRange = 0;
                this.currOffset = this.nextIndex;
                while (this.currOffset >= (rs = CharRangeSet.this.range(this.currRange).length())) {
                    this.currOffset -= rs;
                    ++this.currRange;
                }
            }
        };
    }

    public char first() {
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        return this.range(0).first();
    }

    private char firstFrom(char v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        if ((index = -index - 1) >= this.ranges.size()) {
            Exceptions.setNoFirst();
        }
        return this.range(index).first();
    }

    public char last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        return this.range(this.ranges.size() - 1).last();
    }

    private char lastFrom(char v) {
        int index = this.getRangeIndexOf(v);
        if (index >= 0) {
            return v;
        }
        index = -index - 1;
        if (--index < 0 || index >= this.ranges.size()) {
            Exceptions.setNoLast();
        }
        return this.range(index).last();
    }

    public CharSortedSet headSet(char to) {
        return new SubSet(false, '\u0000', true, to);
    }

    public CharSortedSet tailSet(char from) {
        return new SubSet(true, from, false, '\u0000');
    }

    public CharSortedSet subSet(char from, char to) {
        return new SubSet(true, from, true, to);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        int i = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.range(i));
            ++i;
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            CharRangeSet c = (CharRangeSet)super.clone();
            c.ranges = (ArrayList)this.ranges.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        this.ranges.clear();
        this.size = 0;
    }

    public boolean contains(char v) {
        return this.getRangeIndexOf(v) >= 0;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        boolean index = false;
        int rsize = this.ranges.size();
        while (i < rsize) {
            CharRange r = this.range(i);
            char c = r.first();
            char last = r.last();
            while (c <= last) {
                h += c;
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean remove(char v) {
        int index = this.getRangeIndexOf(v);
        if (index < 0) {
            return false;
        }
        CharRange r = this.range(index);
        if (v == r.first()) {
            if (r.length() == 1) {
                this.ranges.remove(index);
            } else {
                this.ranges.set(index, new CharRange((char)(r.first() + '\u0001'), r.last()));
            }
        } else if (v == r.last()) {
            this.ranges.set(index, new CharRange(r.first(), (char)(r.last() - '\u0001')));
        } else {
            CharRange r1 = new CharRange(r.first(), (char)(v - '\u0001'));
            CharRange r2 = new CharRange((char)(v + '\u0001'), r.last());
            this.ranges.set(index, r1);
            this.ranges.add(index + 1, r2);
        }
        --this.size;
        return true;
    }

    public char[] toArray(char[] a) {
        if (a == null || a.length < this.size) {
            a = new char[this.size];
        }
        int i = 0;
        int index = 0;
        int rsize = this.ranges.size();
        while (i < rsize) {
            CharRange r = this.range(i);
            char c = r.first();
            char last = r.last();
            while (c <= last) {
                a[index++] = c;
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        return a;
    }

    public boolean containsAll(CharRange range) {
        CharRange r = this.getRangeOf(range.first());
        return r != null ? r.contains(range.last()) : false;
    }

    public boolean addAll(CharRangeSet c) {
        int oldSize = this.size;
        int i = 0;
        int rsize = c.ranges.size();
        while (i < rsize) {
            this.addAll(c.range(i));
            ++i;
        }
        return this.size != oldSize;
    }

    public boolean addAll(CharRange range) {
        int oldSize = this.size;
        int index = this.insertRange(range);
        if (index != -1) {
            int nindex = index;
            if (nindex > 0) {
                --nindex;
            }
            this.size += range.length();
            this.normalize(nindex);
        }
        return this.size != oldSize;
    }

    public boolean addAll(char first, char last) {
        return this.addAll(new CharRange(first, last));
    }

    public boolean addAll(char[] a) {
        char[] sa;
        if (a.length == 0) {
            return false;
        }
        int oldSize = this.size;
        if (!this.isSorted(a)) {
            sa = (char[])a.clone();
            Arrays.sort(sa);
        } else {
            sa = a;
        }
        int index = 0;
        while (index < sa.length) {
            char c0 = sa[index];
            index = this.range(sa, index);
            char c1 = sa[index];
            this.ranges.add(new CharRange(c0, c1));
            ++index;
        }
        Collections.sort(this.ranges);
        this.normalize();
        return this.size != oldSize;
    }

    private int range(char[] a, int index) {
        char c0 = a[index++];
        while (index < a.length && a[index] == c0) {
            ++index;
        }
        while (index < a.length && a[index] == (char)(c0 + '\u0001')) {
            c0 = a[index++];
            while (index < a.length && a[index] == c0) {
                ++index;
            }
        }
        return index - 1;
    }

    private boolean isSorted(char[] a) {
        int i = 1;
        while (i < a.length) {
            if (a[i] < a[i - 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CharRange[] ranges() {
        CharRange[] a = new CharRange[this.ranges.size()];
        this.ranges.toArray(a);
        return a;
    }

    private class SubSet
    extends AbstractCharSet
    implements CharSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private char lowerBound;
        private char upperBound;

        SubSet(boolean hasLowerBound, char lowerBound, boolean hasUpperBound, char upperBound) {
            if (hasLowerBound) {
                if (lowerBound < '\u0000') {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(char v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return CharRangeSet.this.add(v);
        }

        public boolean remove(char v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return CharRangeSet.this.remove(v);
        }

        public boolean contains(char v) {
            return this.inSubRange(v) && CharRangeSet.this.contains(v);
        }

        public CharIterator iterator() {
            char first;
            try {
                first = this.first();
            }
            catch (NoSuchElementException e) {
                return new EmptySubSetIterator();
            }
            char last = this.last();
            int rangeIndexLow = CharRangeSet.this.getRangeIndexOf(first);
            int rangeIndexHigh = CharRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                return new SimpleSubSetIterator(first, last);
            }
            return new NonEmptySubSetIterator(first, last, rangeIndexLow, rangeIndexHigh);
        }

        public int size() {
            int size;
            int rangeIndexLow;
            char first;
            if (CharRangeSet.this.size() == 0) {
                return 0;
            }
            try {
                first = this.first();
                rangeIndexLow = CharRangeSet.this.getRangeIndexOf(first);
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            char last = this.last();
            int rangeIndexHigh = CharRangeSet.this.getRangeIndexOf(last);
            if (rangeIndexLow == rangeIndexHigh) {
                size = last - first + 1;
            } else {
                CharRange rangeLow = CharRangeSet.this.range(rangeIndexLow);
                CharRange rangeHigh = CharRangeSet.this.range(rangeIndexHigh);
                int sizeLow = rangeLow.last() - first + 1;
                int sizeHigh = last - rangeHigh.first() + 1;
                size = sizeLow + sizeHigh;
                int i = rangeIndexLow + 1;
                while (i < rangeIndexHigh) {
                    size += CharRangeSet.this.range(i).length();
                    ++i;
                }
            }
            return size;
        }

        public char first() {
            char first = CharRangeSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : (char)'\u0000');
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public char last() {
            char last = CharRangeSet.this.lastFrom(this.hasUpperBound ? (char)(this.upperBound - '\u0001') : CharRangeSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public CharSortedSet headSet(char to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public CharSortedSet tailSet(char from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public CharSortedSet subSet(char from, char to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(char v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class NonEmptySubSetIterator
        implements CharIterator {
            char first;
            char last;
            int rangeIndexLow;
            int rangeIndexHigh;
            CharRange rangeLow;
            CharRange rangeHigh;
            char previousValue;
            CharRange currRange;
            int currRangeIndex;
            int currOffset;
            boolean valueAvailable;
            int nextIndex;

            NonEmptySubSetIterator(char first, char last, int rangeIndexLow, int rangeIndexHigh) {
                if (rangeIndexLow == rangeIndexHigh) {
                    throw new RuntimeException("Internal error");
                }
                this.first = first;
                this.last = last;
                this.rangeIndexLow = rangeIndexLow;
                this.rangeIndexHigh = rangeIndexHigh;
                this.rangeLow = new CharRange(first, CharRangeSet.this.range(rangeIndexLow).last());
                this.rangeHigh = new CharRange(CharRangeSet.this.range(rangeIndexHigh).first(), last);
                this.currRangeIndex = rangeIndexLow;
                this.currRange = this.rangeLow;
                this.currOffset = 0;
                this.previousValue = first;
                this.valueAvailable = false;
                this.nextIndex = 0;
            }

            private CharRange getRange(int rangeIndex) {
                if (rangeIndex == this.rangeIndexLow) {
                    return this.rangeLow;
                }
                if (rangeIndex == this.rangeIndexHigh) {
                    return this.rangeHigh;
                }
                return CharRangeSet.this.range(rangeIndex);
            }

            private void recalc() {
                int rs;
                this.first = SubSet.this.first();
                this.last = SubSet.this.last();
                this.rangeIndexLow = CharRangeSet.this.getRangeIndexOf(this.first);
                this.rangeIndexHigh = CharRangeSet.this.getRangeIndexOf(this.last);
                if (this.rangeIndexLow == this.rangeIndexHigh) {
                    this.rangeLow = this.rangeHigh = new CharRange(this.first, this.last);
                } else {
                    this.rangeLow = new CharRange(this.first, CharRangeSet.this.range(this.rangeIndexLow).last());
                    this.rangeHigh = new CharRange(CharRangeSet.this.range(this.rangeIndexHigh).first(), this.last);
                }
                this.currOffset = this.nextIndex;
                this.currRangeIndex = this.rangeIndexLow;
                this.currRange = this.rangeLow;
                while (this.currOffset >= (rs = this.currRange.length())) {
                    this.currOffset -= rs;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
            }

            public boolean hasNext() {
                return this.previousValue < this.last;
            }

            public char next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.previousValue = (char)(this.currRange.first() + this.currOffset++);
                if (this.currOffset == this.currRange.length() && this.previousValue < this.last) {
                    this.currOffset = 0;
                    this.currRange = this.getRange(++this.currRangeIndex);
                }
                ++this.nextIndex;
                this.valueAvailable = true;
                return this.previousValue;
            }

            public void remove() {
                if (!this.valueAvailable) {
                    Exceptions.noElementToRemove();
                }
                CharRangeSet.this.remove(this.previousValue);
                --this.nextIndex;
                this.recalc();
                this.valueAvailable = false;
            }
        }

        class SimpleSubSetIterator
        implements CharIterator {
            int nextIndex;
            int size;
            int lastIndex;
            char lastValue;
            char from;
            char to;

            SimpleSubSetIterator(char from, char to) {
                this.size = to - from + 1;
                this.nextIndex = 0;
                this.lastIndex = -1;
                this.from = from;
                this.to = to;
            }

            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            public char next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (char)(this.from + this.nextIndex);
                this.lastIndex = this.nextIndex++;
                return this.lastValue;
            }

            public void remove() {
                if (this.lastIndex == -1) {
                    Exceptions.noElementToRemove();
                }
                CharRangeSet.this.remove(this.lastValue);
                this.lastIndex = -1;
            }
        }

        class EmptySubSetIterator
        implements CharIterator {
            EmptySubSetIterator() {
            }

            public boolean hasNext() {
                return false;
            }

            public char next() {
                Exceptions.endOfIterator();
                throw new RuntimeException();
            }

            public void remove() {
                Exceptions.noElementToRemove();
            }
        }
    }
}

