/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.CharCollection;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.map.FloatKeyCharMap;
import bak.pcj.map.FloatKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatKeyCharMap
implements FloatKeyCharMap {
    protected AbstractFloatKeyCharMap() {
    }

    public void clear() {
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public char remove(float key) {
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            char value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultChar();
    }

    public void putAll(FloatKeyCharMap map) {
        FloatKeyCharMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(float key) {
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public char get(float key) {
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultChar();
    }

    public boolean containsValue(char value) {
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatKeyCharMap)) {
            return false;
        }
        FloatKeyCharMap map = (FloatKeyCharMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            float k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultFloatHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultCharHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public char tget(float key) {
        char value = this.get(key);
        if (value == MapDefaults.defaultChar() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        FloatKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract CharCollection values();

    public abstract char put(float var1, char var2);

    public abstract char lget();

    public abstract FloatSet keySet();

    public abstract FloatKeyCharMapIterator entries();
}

