/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.BooleanCollection;
import bak.pcj.hash.DefaultBooleanHashFunction;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.map.FloatKeyBooleanMap;
import bak.pcj.map.FloatKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatKeyBooleanMap
implements FloatKeyBooleanMap {
    protected AbstractFloatKeyBooleanMap() {
    }

    public void clear() {
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean remove(float key) {
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            boolean value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultBoolean();
    }

    public void putAll(FloatKeyBooleanMap map) {
        FloatKeyBooleanMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(float key) {
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public boolean get(float key) {
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultBoolean();
    }

    public boolean containsValue(boolean value) {
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatKeyBooleanMap)) {
            return false;
        }
        FloatKeyBooleanMap map = (FloatKeyBooleanMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            float k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultFloatHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultBooleanHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public boolean tget(float key) {
        boolean value = this.get(key);
        if (value == MapDefaults.defaultBoolean() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        FloatKeyBooleanMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract BooleanCollection values();

    public abstract boolean put(float var1, boolean var2);

    public abstract boolean lget();

    public abstract FloatSet keySet();

    public abstract FloatKeyBooleanMapIterator entries();
}

