/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractShortCollection;
import bak.pcj.ShortCollection;
import bak.pcj.ShortIterator;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.list.ShortList;
import bak.pcj.list.ShortListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortList
extends AbstractShortCollection
implements ShortList {
    protected AbstractShortList() {
    }

    public boolean add(short v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, short v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, ShortCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        ShortIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(short c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, short c) {
        ShortListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public ShortIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(short c) {
        ShortListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, short c) {
        ShortListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public ShortListIterator listIterator() {
        return this.listIterator(0);
    }

    public ShortListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new ShortListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractShortList.this.size();
            }

            public short next() {
                if (this.ptr == AbstractShortList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractShortList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractShortList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(short v) {
                AbstractShortList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public short previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractShortList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(short v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractShortList.this.set(this.lptr, v);
            }
        };
    }

    public short removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortList)) {
            return false;
        }
        ShortListIterator i1 = this.listIterator();
        ShortListIterator i2 = ((ShortList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        ShortIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultShortHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract short set(int var1, short var2);

    public abstract short get(int var1);
}

