/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortIterator;
import bak.pcj.adapter.IteratorToShortIteratorAdapter;
import bak.pcj.set.AbstractShortSet;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToShortSetAdapter
extends AbstractShortSet
implements ShortSet {
    protected Set set;

    public SetToShortSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToShortSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(short v) {
        return this.set.add(new Short(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(short v) {
        return this.set.contains(new Short(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public ShortIterator iterator() {
        return new IteratorToShortIteratorAdapter(this.set.iterator());
    }

    public boolean remove(short v) {
        return this.set.remove(new Short(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isShortAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

