/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleIterator;
import bak.pcj.adapter.IteratorToDoubleIteratorAdapter;
import bak.pcj.set.AbstractDoubleSet;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToDoubleSetAdapter
extends AbstractDoubleSet
implements DoubleSet {
    protected Set set;

    public SetToDoubleSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToDoubleSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(double v) {
        return this.set.add(new Double(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(double v) {
        return this.set.contains(new Double(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public DoubleIterator iterator() {
        return new IteratorToDoubleIteratorAdapter(this.set.iterator());
    }

    public boolean remove(double v) {
        return this.set.remove(new Double(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isDoubleAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

