/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteCollection;
import bak.pcj.adapter.CollectionToByteCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyByteMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyByteMap;
import bak.pcj.map.ObjectKeyByteMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyByteMapAdapter
extends AbstractObjectKeyByteMap
implements ObjectKeyByteMap {
    protected Map map;
    protected Byte lastValue;

    public MapToObjectKeyByteMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyByteMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Byte)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(new Byte(value));
    }

    public ObjectKeyByteMapIterator entries() {
        return new ObjectKeyByteMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyByteMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public byte getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public byte get(Object key) {
        Byte value = (Byte)this.map.get(key);
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public byte lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public byte put(Object key, byte value) {
        Byte oldValue = this.map.put(key, new Byte(value));
        return oldValue == null ? MapDefaults.defaultByte() : oldValue;
    }

    public byte remove(Object key) {
        Byte value = (Byte)this.map.remove(key);
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ByteCollection values() {
        return new CollectionToByteCollectionAdapter(this.map.values());
    }

    public byte tget(Object key) {
        Byte value = (Byte)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyByteAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

