/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.SetToFloatSetAdapter;
import bak.pcj.map.AbstractFloatKeyMap;
import bak.pcj.map.FloatKeyMap;
import bak.pcj.map.FloatKeyMapIterator;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapToFloatKeyMapAdapter
extends AbstractFloatKeyMap
implements FloatKeyMap {
    protected Map map;

    public MapToFloatKeyMapAdapter(Map map) {
        this(map, false);
    }

    public MapToFloatKeyMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(float key) {
        return this.map.get(new Float(key)) != null;
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public FloatKeyMapIterator entries() {
        return new FloatKeyMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToFloatKeyMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public float getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getKey()).floatValue();
            }

            public Object getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public Object get(float key) {
        return this.map.get(new Float(key));
    }

    public FloatSet keySet() {
        return new SetToFloatSetAdapter(this.map.keySet());
    }

    public Object put(float key, Object value) {
        return this.map.put(new Float(key), value);
    }

    public Object remove(float key) {
        return this.map.remove(new Float(key));
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean validate() {
        return Adapter.isFloatKeyAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

