/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.SetToDoubleSetAdapter;
import bak.pcj.map.AbstractDoubleKeyMap;
import bak.pcj.map.DoubleKeyMap;
import bak.pcj.map.DoubleKeyMapIterator;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapToDoubleKeyMapAdapter
extends AbstractDoubleKeyMap
implements DoubleKeyMap {
    protected Map map;

    public MapToDoubleKeyMapAdapter(Map map) {
        this(map, false);
    }

    public MapToDoubleKeyMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(double key) {
        return this.map.get(new Double(key)) != null;
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public DoubleKeyMapIterator entries() {
        return new DoubleKeyMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToDoubleKeyMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public double getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getKey();
            }

            public Object getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public Object get(double key) {
        return this.map.get(new Double(key));
    }

    public DoubleSet keySet() {
        return new SetToDoubleSetAdapter(this.map.keySet());
    }

    public Object put(double key, Object value) {
        return this.map.put(new Double(key), value);
    }

    public Object remove(double key) {
        return this.map.remove(new Double(key));
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean validate() {
        return Adapter.isDoubleKeyAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

