/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatCollection;
import bak.pcj.adapter.CollectionToFloatCollectionAdapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyFloatMap;
import bak.pcj.map.CharKeyFloatMap;
import bak.pcj.map.CharKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyFloatMapAdapter
extends AbstractCharKeyFloatMap
implements CharKeyFloatMap {
    protected Map map;
    protected Float lastValue;

    public MapToCharKeyFloatMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToCharKeyFloatMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        this.lastValue = (Float)this.map.get(new Character(key));
        return this.lastValue != null;
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(new Float(value));
    }

    public CharKeyFloatMapIterator entries() {
        return new CharKeyFloatMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyFloatMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public float getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getValue()).floatValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public float get(char key) {
        Float value = (Float)this.map.get(new Character(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public float lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.floatValue();
    }

    public float put(char key, float value) {
        Float oldValue = this.map.put(new Character(key), new Float(value));
        return oldValue == null ? MapDefaults.defaultFloat() : oldValue.floatValue();
    }

    public float remove(char key) {
        Float value = (Float)this.map.remove(new Character(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public int size() {
        return this.map.size();
    }

    public FloatCollection values() {
        return new CollectionToFloatCollectionAdapter(this.map.values());
    }

    public float tget(char key) {
        Float value = (Float)this.map.get(new Character(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.floatValue();
    }

    public boolean validate() {
        return Adapter.isCharKeyFloatAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

