/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleCollection;
import bak.pcj.adapter.CollectionToDoubleCollectionAdapter;
import bak.pcj.adapter.SetToBooleanSetAdapter;
import bak.pcj.map.AbstractBooleanKeyDoubleMap;
import bak.pcj.map.BooleanKeyDoubleMap;
import bak.pcj.map.BooleanKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToBooleanKeyDoubleMapAdapter
extends AbstractBooleanKeyDoubleMap
implements BooleanKeyDoubleMap {
    protected Map map;
    protected Double lastValue;

    public MapToBooleanKeyDoubleMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToBooleanKeyDoubleMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(boolean key) {
        this.lastValue = (Double)this.map.get(new Boolean(key));
        return this.lastValue != null;
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(new Double(value));
    }

    public BooleanKeyDoubleMapIterator entries() {
        return new BooleanKeyDoubleMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToBooleanKeyDoubleMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public boolean getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getKey();
            }

            public double getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public double get(boolean key) {
        Double value = (Double)this.map.get(new Boolean(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public BooleanSet keySet() {
        return new SetToBooleanSetAdapter(this.map.keySet());
    }

    public double lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(boolean key, double value) {
        Double oldValue = this.map.put(new Boolean(key), new Double(value));
        return oldValue == null ? MapDefaults.defaultDouble() : oldValue;
    }

    public double remove(boolean key) {
        Double value = (Double)this.map.remove(new Boolean(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public int size() {
        return this.map.size();
    }

    public DoubleCollection values() {
        return new CollectionToDoubleCollectionAdapter(this.map.values());
    }

    public double tget(boolean key) {
        Double value = (Double)this.map.get(new Boolean(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isBooleanKeyDoubleAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

