/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.ListIteratorToByteListIteratorAdapter;
import bak.pcj.list.AbstractByteList;
import bak.pcj.list.ByteListIterator;
import bak.pcj.util.Exceptions;
import java.util.List;

public class ListToByteListAdapter
extends AbstractByteList {
    protected List list;

    public ListToByteListAdapter(List list) {
        this(list, false);
    }

    public ListToByteListAdapter(List list, boolean validate) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
        if (validate) {
            this.evalidate();
        }
    }

    public void add(int index, byte v) {
        this.list.add(index, new Byte(v));
    }

    public byte get(int index) {
        return (Byte)this.list.get(index);
    }

    public ByteListIterator listIterator(int index) {
        return new ListIteratorToByteListIteratorAdapter(this.list.listIterator(index));
    }

    public byte removeElementAt(int index) {
        return (Byte)this.list.remove(index);
    }

    public byte set(int index, byte v) {
        return this.list.set(index, new Byte(v));
    }

    public int size() {
        return this.list.size();
    }

    public boolean validate() {
        return Adapter.isByteAdaptable(this.list);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("list");
        }
    }
}

