/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.cinder.v1.domain.VolumeAttachment;

public class Volume {
    private final String id;
    private final Status status;
    private final int size;
    @Named(value="availability_zone")
    private final String zone;
    @Named(value="created_at")
    private final Date created;
    private final Set<VolumeAttachment> attachments;
    @Named(value="volume_type")
    private final String volumeType;
    @Named(value="snapshot_id")
    private final String snapshotId;
    @Named(value="display_name")
    private final String name;
    @Named(value="display_description")
    private final String description;
    private final Map<String, String> metadata;
    @Named(value="os-vol-tenant-attr:tenant_id")
    private final String tenantId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromVolume(this);
    }

    public static Volume forId(String volumeId) {
        return Volume.builder().id(volumeId).status(Status.UNRECOGNIZED).zone("nova").created(new Date()).build();
    }

    @ConstructorProperties(value={"id", "status", "size", "availability_zone", "created_at", "attachments", "volume_type", "snapshot_id", "display_name", "display_description", "metadata", "os-vol-tenant-attr:tenant_id"})
    protected Volume(String id, Status status, int size, String zone, Date created, @Nullable Set<VolumeAttachment> attachments, @Nullable String volumeType, @Nullable String snapshotId, @Nullable String name, @Nullable String description, @Nullable Map<String, String> metadata, @Nullable String tenantId) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.size = size;
        this.zone = zone;
        this.created = (Date)Preconditions.checkNotNull((Object)created, (Object)"created");
        this.attachments = attachments == null ? ImmutableSet.of() : ImmutableSet.copyOf(attachments);
        this.volumeType = volumeType;
        this.snapshotId = snapshotId;
        this.name = name;
        this.description = description;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getSize() {
        return this.size;
    }

    @Nullable
    public String getZone() {
        return this.zone;
    }

    public Date getCreated() {
        return this.created;
    }

    public Set<VolumeAttachment> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public String getVolumeType() {
        return this.volumeType;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.status, this.size, this.zone, this.created, this.attachments, this.volumeType, this.snapshotId, this.name, this.description, this.metadata, this.tenantId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Volume that = (Volume)Volume.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.zone, (Object)that.zone) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal(this.attachments, that.attachments) && Objects.equal((Object)this.volumeType, (Object)that.volumeType) && Objects.equal((Object)this.snapshotId, (Object)that.snapshotId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.metadata, that.metadata) && Objects.equal((Object)this.tenantId, (Object)that.tenantId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("size", this.size).add("zone", (Object)this.zone).add("created", (Object)this.created).add("attachments", this.attachments).add("volumeType", (Object)this.volumeType).add("snapshotId", (Object)this.snapshotId).add("name", (Object)this.name).add("description", (Object)this.description).add("metadata", this.metadata).add("extendedAttributes", (Object)this.tenantId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected String id;
        protected Status status;
        protected int size;
        protected String zone;
        protected Date created;
        protected Set<VolumeAttachment> attachments = ImmutableSet.of();
        protected String volumeType;
        protected String snapshotId;
        protected String name;
        protected String description;
        protected Map<String, String> metadata = ImmutableMap.of();
        protected String tenantId;

        public Builder id(String id) {
            this.id = id;
            return this.self();
        }

        public Builder status(Status status) {
            this.status = status;
            return this.self();
        }

        public Builder size(int size) {
            this.size = size;
            return this.self();
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public Builder created(Date created) {
            this.created = created;
            return this.self();
        }

        public Builder attachments(Set<VolumeAttachment> attachments) {
            this.attachments = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(attachments, (Object)"attachments")));
            return this.self();
        }

        public Builder attachments(VolumeAttachment ... in) {
            return this.attachments((Set<VolumeAttachment>)ImmutableSet.copyOf((Object[])in));
        }

        public Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this.self();
        }

        public Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this.self();
        }

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
            return this.self();
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public Volume build() {
            return new Volume(this.id, this.status, this.size, this.zone, this.created, this.attachments, this.volumeType, this.snapshotId, this.name, this.description, this.metadata, this.tenantId);
        }

        public Builder fromVolume(Volume in) {
            return this.id(in.getId()).status(in.getStatus()).size(in.getSize()).zone(in.getZone()).created(in.getCreated()).attachments(in.getAttachments()).volumeType(in.getVolumeType()).snapshotId(in.getSnapshotId()).name(in.getName()).description(in.getDescription()).metadata(in.getMetadata()).tenantId(in.getTenantId());
        }

        protected Builder self() {
            return this;
        }
    }

    public static enum Status {
        CREATING,
        AVAILABLE,
        ATTACHING,
        IN_USE,
        DELETING,
        ERROR,
        ERROR_DELETING,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

