/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestHostNameResolver;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.CamelContextHelper;

@XmlRootElement(name="restConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestConfigurationDefinition {
    @XmlAttribute
    private String component;
    @XmlAttribute
    private String scheme;
    @XmlAttribute
    private String host;
    @XmlAttribute
    private String port;
    @XmlAttribute
    private String contextPath;
    @XmlAttribute
    private RestHostNameResolver hostNameResolver;
    @XmlAttribute
    private RestBindingMode bindingMode;
    @XmlAttribute
    private Boolean skipBindingOnErrorCode;
    @XmlAttribute
    private Boolean enableCORS;
    @XmlAttribute
    private String jsonDataFormat;
    @XmlAttribute
    private String xmlDataFormat;
    @XmlElement(name="componentProperty")
    private List<RestPropertyDefinition> componentProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="endpointProperty")
    private List<RestPropertyDefinition> endpointProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="consumerProperty")
    private List<RestPropertyDefinition> consumerProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="dataFormatProperty")
    private List<RestPropertyDefinition> dataFormatProperties = new ArrayList<RestPropertyDefinition>();
    @XmlElement(name="corsHeaders")
    private List<RestPropertyDefinition> corsHeaders = new ArrayList<RestPropertyDefinition>();

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RestHostNameResolver getHostNameResolver() {
        return this.hostNameResolver;
    }

    public void setHostNameResolver(RestHostNameResolver hostNameResolver) {
        this.hostNameResolver = hostNameResolver;
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public Boolean getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(Boolean enableCORS) {
        this.enableCORS = enableCORS;
    }

    public String getJsonDataFormat() {
        return this.jsonDataFormat;
    }

    public void setJsonDataFormat(String jsonDataFormat) {
        this.jsonDataFormat = jsonDataFormat;
    }

    public String getXmlDataFormat() {
        return this.xmlDataFormat;
    }

    public void setXmlDataFormat(String xmlDataFormat) {
        this.xmlDataFormat = xmlDataFormat;
    }

    public List<RestPropertyDefinition> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(List<RestPropertyDefinition> componentProperties) {
        this.componentProperties = componentProperties;
    }

    public List<RestPropertyDefinition> getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(List<RestPropertyDefinition> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public List<RestPropertyDefinition> getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(List<RestPropertyDefinition> consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    public List<RestPropertyDefinition> getDataFormatProperties() {
        return this.dataFormatProperties;
    }

    public void setDataFormatProperties(List<RestPropertyDefinition> dataFormatProperties) {
        this.dataFormatProperties = dataFormatProperties;
    }

    public List<RestPropertyDefinition> getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(List<RestPropertyDefinition> corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public RestConfigurationDefinition component(String componentId) {
        this.setComponent(componentId);
        return this;
    }

    public RestConfigurationDefinition scheme(String scheme) {
        this.setScheme(scheme);
        return this;
    }

    public RestConfigurationDefinition host(String host) {
        this.setHost(host);
        return this;
    }

    public RestConfigurationDefinition port(int port) {
        this.setPort("" + port);
        return this;
    }

    public RestConfigurationDefinition port(String port) {
        this.setPort(port);
        return this;
    }

    public RestConfigurationDefinition contextPath(String contextPath) {
        this.setContextPath(contextPath);
        return this;
    }

    public RestConfigurationDefinition hostNameResolver(RestHostNameResolver hostNameResolver) {
        this.setHostNameResolver(hostNameResolver);
        return this;
    }

    public RestConfigurationDefinition bindingMode(RestBindingMode bindingMode) {
        this.setBindingMode(bindingMode);
        return this;
    }

    public RestConfigurationDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        this.setSkipBindingOnErrorCode(skipBindingOnErrorCode);
        return this;
    }

    public RestConfigurationDefinition enableCORS(boolean enableCORS) {
        this.setEnableCORS(enableCORS);
        return this;
    }

    public RestConfigurationDefinition jsonDataFormat(String name) {
        this.setJsonDataFormat(name);
        return this;
    }

    public RestConfigurationDefinition xmlDataFormat(String name) {
        this.setXmlDataFormat(name);
        return this;
    }

    public RestConfigurationDefinition componentProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getComponentProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition endpointProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getEndpointProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition consumerProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getConsumerProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition dataFormatProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getDataFormatProperties().add(prop);
        return this;
    }

    public RestConfigurationDefinition corsHeaderProperty(String key, String value) {
        RestPropertyDefinition prop = new RestPropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.getCorsHeaders().add(prop);
        return this;
    }

    public RestConfiguration asRestConfiguration(CamelContext context) throws Exception {
        String value;
        String key;
        HashMap<String, Object> props;
        RestConfiguration answer = new RestConfiguration();
        if (this.component != null) {
            answer.setComponent(CamelContextHelper.parseText(context, this.component));
        }
        if (this.scheme != null) {
            answer.setScheme(CamelContextHelper.parseText(context, this.scheme));
        }
        if (this.host != null) {
            answer.setHost(CamelContextHelper.parseText(context, this.host));
        }
        if (this.port != null) {
            answer.setPort(CamelContextHelper.parseInteger(context, this.port));
        }
        if (this.contextPath != null) {
            answer.setContextPath(CamelContextHelper.parseText(context, this.contextPath));
        }
        if (this.hostNameResolver != null) {
            answer.setRestHostNameResolver(this.hostNameResolver.name());
        }
        if (this.bindingMode != null) {
            answer.setBindingMode(this.bindingMode.name());
        }
        if (this.skipBindingOnErrorCode != null) {
            answer.setSkipBindingOnErrorCode(this.skipBindingOnErrorCode);
        }
        if (this.enableCORS != null) {
            answer.setEnableCORS(this.enableCORS);
        }
        if (this.jsonDataFormat != null) {
            answer.setJsonDataFormat(this.jsonDataFormat);
        }
        if (this.xmlDataFormat != null) {
            answer.setXmlDataFormat(this.xmlDataFormat);
        }
        if (!this.componentProperties.isEmpty()) {
            props = new HashMap<String, Object>();
            for (RestPropertyDefinition prop : this.componentProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText(context, prop.getValue());
                props.put(key, value);
            }
            answer.setComponentProperties(props);
        }
        if (!this.endpointProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.endpointProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText(context, prop.getValue());
                props.put(key, value);
            }
            answer.setEndpointProperties(props);
        }
        if (!this.consumerProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.consumerProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText(context, prop.getValue());
                props.put(key, value);
            }
            answer.setConsumerProperties(props);
        }
        if (!this.dataFormatProperties.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.dataFormatProperties) {
                key = prop.getKey();
                value = CamelContextHelper.parseText(context, prop.getValue());
                props.put(key, value);
            }
            answer.setDataFormatProperties(props);
        }
        if (!this.corsHeaders.isEmpty()) {
            props = new HashMap();
            for (RestPropertyDefinition prop : this.corsHeaders) {
                key = prop.getKey();
                value = CamelContextHelper.parseText(context, prop.getValue());
                props.put(key, value);
            }
            answer.setCorsHeaders(props);
        }
        return answer;
    }
}

