/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="csv")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CsvDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private Boolean autogenColumns;
    @XmlAttribute
    private String delimiter;
    @XmlAttribute
    private String configRef;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private Boolean skipFirstLine;
    @XmlAttribute
    private Boolean lazyLoad;
    @XmlAttribute
    private Boolean useMaps;

    public CsvDataFormat() {
        super("csv");
    }

    public CsvDataFormat(String delimiter) {
        this();
        this.setDelimiter(delimiter);
    }

    public CsvDataFormat(boolean lazyLoad) {
        this();
        this.setLazyLoad(lazyLoad);
    }

    public Boolean isAutogenColumns() {
        return this.autogenColumns;
    }

    public void setAutogenColumns(Boolean autogenColumns) {
        this.autogenColumns = autogenColumns;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public void setConfigRef(String configRef) {
        this.configRef = configRef;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public Boolean isSkipFirstLine() {
        return this.autogenColumns;
    }

    public void setSkipFirstLine(Boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public Boolean getLazyLoad() {
        return this.lazyLoad;
    }

    public void setLazyLoad(Boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
    }

    public Boolean getUseMaps() {
        return this.useMaps;
    }

    public void setUseMaps(Boolean useMaps) {
        this.useMaps = useMaps;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        DataFormat csvFormat = super.createDataFormat(routeContext);
        if (ObjectHelper.isNotEmpty(this.configRef)) {
            Object config = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.configRef);
            this.setProperty(routeContext.getCamelContext(), csvFormat, "config", config);
        }
        if (ObjectHelper.isNotEmpty(this.strategyRef)) {
            Object strategy = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.strategyRef);
            this.setProperty(routeContext.getCamelContext(), csvFormat, "strategy", strategy);
        }
        return csvFormat;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.autogenColumns != null) {
            this.setProperty(camelContext, dataFormat, "autogenColumns", this.autogenColumns);
        }
        if (this.delimiter != null) {
            if (this.delimiter.length() > 1) {
                throw new IllegalArgumentException("Delimiter must have a length of one!");
            }
            this.setProperty(camelContext, dataFormat, "delimiter", this.delimiter);
        } else {
            this.setProperty(camelContext, dataFormat, "delimiter", ",");
        }
        if (this.skipFirstLine != null) {
            this.setProperty(camelContext, dataFormat, "skipFirstLine", this.skipFirstLine);
        }
        if (this.lazyLoad != null) {
            this.setProperty(camelContext, dataFormat, "lazyLoad", this.lazyLoad);
        }
        if (this.useMaps != null) {
            this.setProperty(camelContext, dataFormat, "useMaps", this.useMaps);
        }
    }
}

