/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.loadbalancer.strategy.LoadBalanceNodesStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;

@Singleton
public class CloudLoadBalancersLoadBalanceNodesStrategy
implements LoadBalanceNodesStrategy {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    protected final CloudLoadBalancersApi client;
    protected final GetLoadBalancerMetadataStrategy getLB;

    @Inject
    protected CloudLoadBalancersLoadBalanceNodesStrategy(CloudLoadBalancersApi client, GetLoadBalancerMetadataStrategy getLB) {
        this.client = (CloudLoadBalancersApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.getLB = (GetLoadBalancerMetadataStrategy)Preconditions.checkNotNull((Object)getLB, (Object)"getLB");
    }

    public LoadBalancerMetadata createLoadBalancerInLocation(Location location, String name, String protocol, int loadBalancerPort, final int instancePort, Iterable<? extends NodeMetadata> nodes) {
        String region = ((Location)Preconditions.checkNotNull((Object)location, (Object)"location")).getId();
        LoadBalancer lb = this.client.getLoadBalancerApi(region).create(((CreateLoadBalancer.Builder)CreateLoadBalancer.builder().name(name).protocol(protocol.toUpperCase()).port(loadBalancerPort).virtualIPType(VirtualIP.Type.PUBLIC).nodes(Iterables.transform(nodes, (Function)new Function<NodeMetadata, AddNode>(){

            public AddNode apply(NodeMetadata arg0) {
                return AddNode.builder().address((String)Iterables.get((Iterable)arg0.getPrivateAddresses(), (int)0)).port(instancePort).build();
            }
        }))).build());
        return this.getLB.getLoadBalancer(region + "/" + lb.getId());
    }
}

