/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.XMLTypeHelper;
import org.geotools.xml.handlers.xsi.ComplexTypeHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.SimpleTypeHandler;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Type;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class ElementTypeHandler
extends ElementGroupingHandler {
    public static final String LOCALNAME = "element";
    private static int offset = 0;
    private String id;
    private String name;
    private String type;
    private String ref = null;
    private String defaulT;
    private String fixed;
    private String substitutionGroup;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private int finaL;
    private int block;
    private boolean form;
    private boolean abstracT;
    private boolean nillable;
    private Object child;
    private int hashCodeOffset = ElementTypeHandler.getOffset();
    private DefaultElement cache = null;

    private static int getOffset() {
        return offset++;
    }

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) * (this.ref == null ? 1 : this.ref.hashCode()) * (this.name == null ? 1 : this.name.hashCode()) + this.hashCodeOffset;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI)) {
            if ("simpleType".equalsIgnoreCase(localName)) {
                SimpleTypeHandler sth = new SimpleTypeHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("Extension may only have one 'simpleType' or 'complexType' declaration.");
                }
                this.child = sth;
                return sth;
            }
            if ("complexType".equalsIgnoreCase(localName)) {
                ComplexTypeHandler sth = new ComplexTypeHandler();
                if (this.child != null) {
                    throw new SAXNotRecognizedException("Extension may only have one 'simpleType' or 'complexType' declaration.");
                }
                this.child = sth;
                return sth;
            }
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) throws SAXException {
        String nillable1;
        String maxOccurs1;
        String form1;
        String finaL1;
        String abstracT1 = atts.getValue("", "abstracT");
        if (abstracT1 == null) {
            abstracT1 = atts.getValue(namespaceURI, "abstracT");
        }
        this.abstracT = abstracT1 == null || "".equalsIgnoreCase(abstracT1) ? false : Boolean.getBoolean(abstracT1);
        String block1 = atts.getValue("", "block");
        if (block1 == null) {
            block1 = atts.getValue(namespaceURI, "block");
        }
        this.block = ComplexTypeHandler.findBlock(block1);
        this.defaulT = atts.getValue("", "default");
        if (this.defaulT == null) {
            this.defaulT = atts.getValue(namespaceURI, "default");
        }
        if ((finaL1 = atts.getValue("", "final")) == null) {
            finaL1 = atts.getValue(namespaceURI, "final");
        }
        this.finaL = ComplexTypeHandler.findFinal(finaL1);
        this.fixed = atts.getValue("", "fixed");
        if (this.fixed == null) {
            this.fixed = atts.getValue(namespaceURI, "fixed");
        }
        if ((form1 = atts.getValue("", "form")) == null) {
            form1 = atts.getValue(namespaceURI, "form");
        }
        this.form = "qualified".equalsIgnoreCase(form1);
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((maxOccurs1 = atts.getValue("", "maxOccurs")) == null) {
            maxOccurs1 = atts.getValue(namespaceURI, "maxOccurs");
        }
        this.maxOccurs = maxOccurs1 != null && !"".equalsIgnoreCase(maxOccurs1) ? ("unbounded".equalsIgnoreCase(maxOccurs1) ? Integer.MAX_VALUE : Integer.parseInt(maxOccurs1)) : 1;
        String minOccurs1 = atts.getValue("", "minOccurs");
        if (minOccurs1 == null) {
            minOccurs1 = atts.getValue(namespaceURI, "minOccurs");
        }
        this.minOccurs = minOccurs1 != null && !"".equalsIgnoreCase(minOccurs1) ? Integer.parseInt(minOccurs1) : 1;
        this.name = atts.getValue("", "name");
        if (this.name == null) {
            this.name = atts.getValue(namespaceURI, "name");
        }
        if ((nillable1 = atts.getValue("", "nillable")) == null) {
            nillable1 = atts.getValue(namespaceURI, "nillable");
        }
        this.nillable = nillable1 == null || "".equalsIgnoreCase(nillable1) ? false : Boolean.valueOf(nillable1);
        this.ref = atts.getValue("", "ref");
        if (this.ref == null) {
            this.ref = atts.getValue(namespaceURI, "ref");
        }
        this.substitutionGroup = atts.getValue("", "substitutionGroup");
        if (this.substitutionGroup == null) {
            this.substitutionGroup = atts.getValue(namespaceURI, "substitutionGroup");
        }
        this.type = atts.getValue("", "type");
        if (this.type == null) {
            this.type = atts.getValue(namespaceURI, "type");
        }
        if (this.ref != null && !this.ref.isEmpty()) {
            if (this.name != null && !this.name.isEmpty()) {
                throw new SAXException(String.format("Schema element declaration cannot have both 'ref' and 'name' attributes (ref=\"%s\", name=\"%s\")", this.ref, this.name));
            }
            if (this.type != null && !this.type.isEmpty()) {
                throw new SAXException(String.format("Schema element declaration cannot have both 'ref' and 'type' attributes (ref=\"%s\", type=\"%s\")", this.ref, this.type));
            }
            this.name = this.type = this.ref;
        }
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ElementGrouping compress(SchemaHandler parent) throws SAXException {
        ElementTypeHandler elementTypeHandler = this;
        synchronized (elementTypeHandler) {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = new DefaultElement();
        }
        this.cache.id = this.id;
        this.cache.name = this.name;
        this.cache.namespace = parent.getTargetNamespace();
        this.cache.defaulT = this.defaulT;
        this.cache.fixed = this.fixed;
        this.cache.block = this.block;
        this.cache.finaL = this.finaL;
        this.cache.abstracT = this.abstracT;
        this.cache.form = this.form;
        this.cache.nillable = this.nillable;
        this.cache.minOccurs = this.minOccurs;
        this.cache.maxOccurs = this.maxOccurs;
        if (this.substitutionGroup != null) {
            this.cache.substitutionGroup = parent.lookUpElement(this.substitutionGroup);
        }
        this.cache.type = this.child == null ? parent.lookUpType(this.type) : (this.child instanceof SimpleTypeHandler ? ((SimpleTypeHandler)this.child).compress(parent) : ((ComplexTypeHandler)this.child).compress(parent));
        if (this.ref != null) {
            Element e = parent.lookUpElement(this.ref);
            if (e == null) {
                throw new SAXException("Element '" + this.ref + "' was referenced and not found");
            }
            this.cache.name = e.getName();
            this.cache.type = e.getType();
            if (this.defaulT == null || "".equalsIgnoreCase(this.defaulT)) {
                this.cache.defaulT = e.getDefault();
            }
            if (this.fixed == null || "".equalsIgnoreCase(this.fixed)) {
                this.cache.fixed = e.getFixed();
            }
            if (this.block == 0) {
                this.cache.block = e.getBlock();
            }
            if (this.finaL == 0) {
                this.cache.finaL = e.getFinal();
            }
            this.cache.minOccurs = this.minOccurs == 1 ? e.getMinOccurs() : this.minOccurs;
            int n = this.cache.maxOccurs = this.maxOccurs == 1 ? e.getMaxOccurs() : this.maxOccurs;
            if (this.substitutionGroup != null) {
                this.cache.substitutionGroup = e.getSubstitutionGroup();
            }
        }
        return this.cache;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }

    private static class DefaultElement
    implements Element {
        int block;
        int finaL;
        boolean abstracT;
        boolean form;
        boolean nillable;
        int maxOccurs;
        int minOccurs;
        String name;
        String id;
        String defaulT;
        String fixed;
        URI namespace;
        Element substitutionGroup;
        Type type;

        private DefaultElement() {
        }

        @Override
        public Element findChildElement(String name1) {
            if (this.name != null && this.name.equalsIgnoreCase(name1)) {
                return this;
            }
            return this.type == null ? null : this.type.findChildElement(name1);
        }

        @Override
        public boolean isAbstract() {
            return this.abstracT;
        }

        @Override
        public int getBlock() {
            return this.block;
        }

        @Override
        public String getDefault() {
            return this.defaulT;
        }

        @Override
        public int getFinal() {
            return this.finaL;
        }

        @Override
        public String getFixed() {
            return this.fixed;
        }

        @Override
        public boolean isForm() {
            return this.form;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNillable() {
            return this.nillable;
        }

        @Override
        public Element getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getGrouping() {
            return 1;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public URI getNamespace() {
            return this.namespace;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.name != null && this.name.equalsIgnoreCase(localName) && this.getNamespace().equals(namespaceURI)) {
                return this;
            }
            return this.type == null ? null : XMLTypeHelper.findChildElement(this.type, localName, namespaceURI);
        }
    }
}

