/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.service;

import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.search.impl.StatelessQueryService;
import org.jzkit.service.JZKitServiceFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class JZKitService
implements Referenceable {
    public static Log log = LogFactory.getLog(JZKitService.class);
    private ApplicationContext ctx = null;
    private String jzkit_home = null;

    public static void main(String[] args) {
        try {
            log.info((Object)("Starting jzkit2 service..." + args));
            ClassPathXmlApplicationContext app_context = new ClassPathXmlApplicationContext(args);
            log.info((Object)"JZKit server startup completed");
        }
        catch (Exception e) {
            log.warn((Object)"Problem", (Throwable)e);
        }
    }

    private JZKitService() {
    }

    public JZKitService(String jzkit_home) {
        this.jzkit_home = jzkit_home;
    }

    public void init() {
        try {
            log.debug((Object)("init - jzkit_home=" + this.jzkit_home));
            String app_ctx = "file:///" + this.jzkit_home + "/etc/JZKitServiceAppCtx.xml";
            log.debug((Object)("app_ctx=\"" + app_ctx + "\", creating app ctx"));
            this.ctx = new FileSystemXmlApplicationContext(app_ctx);
        }
        catch (Exception e) {
            log.error((Object)"Problem loading configuration", (Throwable)e);
        }
    }

    public Reference getReference() {
        Reference ref = new Reference(JZKitService.class.getName(), JZKitServiceFactory.class.getName(), null);
        ref.add(new StringRefAddr("jzkit_home", this.jzkit_home));
        return ref;
    }

    public static JZKitService create(String jzkit_home) {
        JZKitService result = new JZKitService(jzkit_home);
        result.init();
        return result;
    }

    public Configuration getConfig() {
        Configuration result = null;
        if (this.ctx != null) {
            result = (Configuration)this.ctx.getBean("JZKitConfig");
        }
        return result;
    }

    public ApplicationContext getCtx() {
        return this.ctx;
    }

    public StatelessQueryService getStatelessQueryService() {
        return (StatelessQueryService)this.ctx.getBean("StatelessQueryService");
    }
}

