/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.Profile;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.ServiceDirectory.AttributeSetDBO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.search.util.Profile.AttrMappingDBO;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.Profile.ProfileDBO;
import org.jzkit.search.util.Profile.ProfileService;
import org.jzkit.search.util.Profile.ProfileServiceException;
import org.jzkit.search.util.Profile.QueryVerifyResult;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceImpl
implements ProfileService,
ApplicationContextAware {
    private static Log log = LogFactory.getLog(ProfileServiceImpl.class);
    private ApplicationContext ctx = null;
    private Configuration configuration = null;
    private static final int SEMANTIC_ACTION_STRICT = 1;
    private static final int SEMANTIC_ACTION_STRIP = 2;
    private static final int SEMANTIC_ACTION_FUZZY = 3;

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public InternalModelRootNode makeConformant(QueryModel qm, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, String profile_code) throws ProfileServiceException {
        InternalModelRootNode result = null;
        log.debug((Object)("makeConformant profile:" + profile_code + " query:" + qm.toString()));
        try {
            ProfileDBO p = this.configuration.lookupProfile(profile_code);
            if (p == null && valid_attributes == null) {
                log.debug((Object)"No profile defined and no valid attributes list, unable to rewrite");
                result = qm.toInternalQueryModel(this.ctx);
            } else {
                log.debug((Object)"Rewriting");
                result = (InternalModelRootNode)this.visit((QueryNode)qm.toInternalQueryModel(this.ctx), null, valid_attributes, service_specific_rewrite_rules, p);
            }
        }
        catch (InvalidQueryException iqe) {
            throw new ProfileServiceException(iqe.toString());
        }
        catch (ConfigurationException ce) {
            throw new ProfileServiceException(ce.toString());
        }
        return result;
    }

    private QueryNode visit(QueryNode qn, String default_namespace, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, ProfileDBO p) throws InvalidQueryException, ProfileServiceException {
        if (qn == null) {
            throw new InvalidQueryException("Query node was null, unable to rewrite");
        }
        log.debug((Object)("Rewrite: visit instance of " + qn.getClass().getName()));
        if (qn instanceof InternalModelRootNode) {
            InternalModelRootNode imrn = (InternalModelRootNode)qn;
            return new InternalModelRootNode(this.visit(imrn.getChild(), default_namespace, valid_attributes, service_specific_rewrite_rules, p));
        }
        if (qn instanceof InternalModelNamespaceNode) {
            InternalModelNamespaceNode imns = (InternalModelNamespaceNode)qn;
            log.debug((Object)("child default attrset will be " + imns.getAttrset()));
            return new InternalModelNamespaceNode(imns.getAttrset(), this.visit(imns.getChild(), imns.getAttrset(), valid_attributes, service_specific_rewrite_rules, p));
        }
        if (qn instanceof ComplexNode) {
            ComplexNode cn = (ComplexNode)qn;
            QueryNode lhs = null;
            QueryNode rhs = null;
            if (cn.getLHS() != null && cn.getLHS().countChildrenWithTerms() > 0) {
                lhs = this.visit(cn.getLHS(), default_namespace, valid_attributes, service_specific_rewrite_rules, p);
            }
            if (cn.getRHS() != null && cn.getRHS().countChildrenWithTerms() > 0) {
                rhs = this.visit(cn.getRHS(), default_namespace, valid_attributes, service_specific_rewrite_rules, p);
            }
            if (lhs != null && rhs != null) {
                return new ComplexNode(lhs, rhs, cn.getOp());
            }
            if (lhs != null) {
                return lhs;
            }
            return rhs;
        }
        if (qn instanceof AttrPlusTermNode) {
            AttrPlusTermNode aptn = null;
            aptn = valid_attributes != null && service_specific_rewrite_rules != null && valid_attributes.size() > 0 ? this.rewriteUntilValid((AttrPlusTermNode)qn, valid_attributes, service_specific_rewrite_rules, default_namespace) : this.rewriteUntilValid((AttrPlusTermNode)qn, p, default_namespace);
            if (aptn == null) {
                throw new ProfileServiceException("Unable to rewrite node. Semantic action was set to strict, and there appears to be no valid alternatives for node " + qn, 3);
            }
            return aptn;
        }
        throw new ProfileServiceException("Should never be here");
    }

    private AttrPlusTermNode rewriteUntilValid(AttrPlusTermNode q, Map<String, AttributeSetDBO> valid_attributes, Map<String, AttrValue> service_specific_rewrite_rules, String default_namespace) throws InvalidQueryException, ProfileServiceException {
        AttrPlusTermNode result = q;
        Iterator i = q.getAttrIterator();
        while (i.hasNext()) {
            String attr_type = (String)i.next();
            AttrValue av = (AttrValue)q.getAttr(attr_type);
            log.debug((Object)("Rewriting " + attr_type + "=" + av));
            AttributeSetDBO as = valid_attributes.get(attr_type);
            if (as == null) {
                throw new ProfileServiceException("No " + attr_type + " attr types allowed for target repository", 4);
            }
            AttrValue new_av = this.rewriteUntilValid(av, as.getAttrs(), service_specific_rewrite_rules, default_namespace);
            log.debug((Object)("Setting attr " + attr_type + " to " + new_av));
            q.setAttr(attr_type, (Object)new_av);
        }
        log.debug((Object)q.getAttrs());
        return result;
    }

    private AttrValue rewriteUntilValid(AttrValue av, Set<AttrValue> explain_use_indexes, Map<String, AttrValue> service_specific_rewrite_rules, String default_namespace) throws ProfileServiceException {
        AttrValue result = av;
        if (av != null) {
            String av_str_val = av.getWithDefaultNamespace(default_namespace);
            if (explain_use_indexes.contains(av)) {
                log.debug((Object)("No need to rewrite, source index " + av + " is already allowed by target"));
            } else {
                log.debug((Object)("Rewrite, source index " + av + " is disallowed, scanning server alternatives allowed=" + explain_use_indexes));
                boolean found = false;
                Iterator<Map.Entry<String, AttrValue>> i = service_specific_rewrite_rules.entrySet().iterator();
                while (i.hasNext() && !found) {
                    Map.Entry<String, AttrValue> e = i.next();
                    if (!e.getKey().equals(av_str_val)) continue;
                    AttrValue new_av = e.getValue();
                    log.debug((Object)("Possible rewrite: " + new_av));
                    if (!explain_use_indexes.contains(new_av)) continue;
                    log.debug((Object)"Matched, replacing");
                    result = new_av;
                    found = true;
                }
                if (!found) {
                    log.debug((Object)"Unable to rewrite query, exception");
                    throw new ProfileServiceException("Unable to rewrite access point '" + av_str_val + "' to comply with service explain record", 3);
                }
            }
        }
        return result;
    }

    private AttrPlusTermNode rewriteUntilValid(AttrPlusTermNode q, ProfileDBO p, String default_namespace) throws ProfileServiceException {
        log.debug((Object)("rewriteUntilValid.... def ns = " + default_namespace));
        QueryVerifyResult qvr = p.validate(q, default_namespace);
        AttrPlusTermNode result = null;
        if (qvr.queryIsValid()) {
            log.debug((Object)"Node is conformant to profile.... return it");
            result = q;
        } else {
            log.debug((Object)("Node does not conform to profile (" + q.getAccessPoint() + " not allowed by profile " + p.getCode() + ")"));
            String failing_attr_type = qvr.getFailingAttr();
            AttrValue av = (AttrValue)q.getAttr(failing_attr_type);
            if (av != null) {
                Set<AttrValue> possible_alternatives = this.lookupKnownAlternatives(av, default_namespace);
                if (possible_alternatives != null) {
                    log.debug((Object)("Check out alternatives for " + failing_attr_type + ":" + possible_alternatives));
                    Iterator<AttrValue> i = possible_alternatives.iterator();
                    while (i.hasNext() && result == null) {
                        AttrValue target_av = i.next();
                        AttrPlusTermNode new_variant = q.cloneForAttrs();
                        new_variant.setAttr(failing_attr_type, (Object)target_av);
                        result = this.rewriteUntilValid(new_variant, p, default_namespace);
                    }
                } else {
                    log.debug((Object)"No expansions available. Return null");
                }
            } else {
                log.debug((Object)("Hmm.. It appears that we failed because a rule required an attr type which is not present in the query tree(" + failing_attr_type + "). Perhaps we should add missing attrs ;)"));
            }
        }
        return result;
    }

    private Set<AttrValue> lookupKnownAlternatives(AttrValue av, String default_namespace) {
        Set<AttrValue> result = null;
        try {
            String namespace = av.getNamespaceIdentifier();
            if (namespace == null) {
                namespace = default_namespace;
            }
            log.debug((Object)("Lookup mappings from namespace " + namespace + " attr value = " + av.getValue()));
            CrosswalkDBO cw = this.configuration.lookupCrosswalk(namespace);
            if (cw != null) {
                AttrMappingDBO am = cw.lookupMapping(av.getValue().toString());
                if (am != null) {
                    result = am.getTargetAttrs();
                }
            } else {
                log.warn((Object)("No crosswalk available for source namespace " + namespace));
            }
        }
        catch (ConfigurationException ce) {
            log.warn((Object)("Problem looking up alternatives for " + av.getValue().toString()), (Throwable)ce);
        }
        return result;
    }
}

