/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.Profile;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionOfElements;
import org.jzkit.search.util.Profile.CrosswalkDBO;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="JZ_CROSSWALK_ATTR_MAPPING")
public class AttrMappingDBO {
    private Long id = null;
    private Set target_attrs = new HashSet();
    private String source_attr_value = null;
    private CrosswalkDBO parent = null;

    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void addTarget(String namespace_identifier, Object value) {
        this.target_attrs.add(new AttrValue(namespace_identifier, value.toString()));
    }

    public String toString() {
        if (this.target_attrs != null) {
            return this.target_attrs.toString();
        }
        return "Empty target attr list";
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="JZ_ATTR_MAPPING_TARGET", joinColumns={@JoinColumn(name="ATTR_MAPPING_FK")})
    public Set<AttrValue> getTargetAttrs() {
        return this.target_attrs;
    }

    public void setTargetAttrs(Set<AttrValue> target_attrs) {
        this.target_attrs = target_attrs;
    }

    @Column(name="SOURCE_ATTR_VALUE", length=64)
    public String getSourceAttrValue() {
        return this.source_attr_value;
    }

    public void setSourceAttrValue(String value) {
        this.source_attr_value = value;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="CROSSWALK_FK")
    public CrosswalkDBO getParent() {
        return this.parent;
    }

    public void setParent(CrosswalkDBO parent) {
        this.parent = parent;
    }
}

