/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.impl.CachedSearchSession;

public class LRUCache
extends Thread {
    private final float hashTableLoadFactor = 0.75f;
    private Map map;
    private int cacheSize = 10;
    private long evict_timeout = 0L;
    private static Log log = LogFactory.getLog(LRUCache.class);
    private boolean running = true;

    public LRUCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public LRUCache(int cacheSize, long evict_timeout) {
        log.debug((Object)("LRUCache::LRUCache(" + cacheSize + "," + evict_timeout + ")"));
        this.cacheSize = cacheSize;
        this.evict_timeout = evict_timeout;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = Collections.synchronizedMap(new LinkedHashMap(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > LRUCache.this.cacheSize && eldest.getValue() != null) {
                    log.info((Object)"** Cache size exceeds max, evict oldest **");
                    if (eldest.getValue() instanceof CachedSearchSession) {
                        ((CachedSearchSession)eldest.getValue()).setActive(false);
                        log.info((Object)("** EVICT: Closing eldest search session " + eldest + " **"));
                        ((CachedSearchSession)eldest.getValue()).close();
                    } else {
                        log.info((Object)("** EVICT: cant evice eldest instance of " + eldest.getValue().getClass().getName()));
                    }
                    return true;
                }
                return false;
            }
        });
        if (evict_timeout > 0L) {
            log.debug((Object)"Starting evict thread");
            this.setDaemon(true);
            this.setName("Cached Search Session Expiry Thread");
            this.start();
        } else {
            log.info((Object)"No LRU evict thread");
        }
    }

    public int size() {
        if (this.map != null) {
            return this.map.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug((Object)"Starting LRU expunge thread");
        while (this.running) {
            try {
                LRUCache.sleep(60000L);
                this.expunge();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public synchronized void expunge() {
        log.debug((Object)("Running Expunge.  there are currently " + this.map.size() + " cached search sessions. Free Memory = " + Runtime.getRuntime().freeMemory()));
        long now = System.currentTimeMillis();
        Object[] keys = this.map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            CachedSearchSession css;
            long inactive_for;
            Object key = keys[i];
            Object o = this.map.get(key);
            if (!(o instanceof CachedSearchSession) || (inactive_for = now - (css = (CachedSearchSession)o).getLastUsed()) <= this.evict_timeout) continue;
            log.debug((Object)("Evict " + key + " - Inactive for " + inactive_for + " > " + this.evict_timeout));
            css.setActive(false);
            this.map.remove(key);
            css.close();
        }
        log.debug((Object)("After expunge there are " + this.map.size() + " cached search sessions, with " + Runtime.getRuntime().freeMemory() + " free memory"));
        log.debug((Object)("CachedSearchSession instance count = " + CachedSearchSession.inst_count));
    }

    public synchronized Object get(Object key) {
        return this.map.get(key);
    }

    public synchronized void put(Object key, Object value) {
        this.map.put(key, value);
    }

    public synchronized void remove(Object key) {
        CachedSearchSession css = (CachedSearchSession)this.map.remove(key);
        if (css != null) {
            css.setActive(false);
            css.close();
        }
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int usedEntries() {
        return this.map.size();
    }

    public synchronized Collection getAll() {
        return new ArrayList(this.map.entrySet());
    }
}

