/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.util.Assert;

public class StringQueryParameterBinder
extends ParameterBinder {
    private final StringQuery query;

    public StringQueryParameterBinder(JpaParameters parameters, Object[] values, StringQuery query) {
        super(parameters, values);
        Assert.notNull((Object)query, (String)"StringQuery must not be null!");
        this.query = query;
    }

    @Override
    protected void bind(Query jpaQuery, JpaParameters.JpaParameter methodParameter, Object value, int position) {
        StringQuery.LikeBinding binding;
        Object valueToBind = value;
        if (this.query.hasLikeBindings() && (binding = this.getBindingFor(jpaQuery, position, methodParameter)) != null) {
            valueToBind = binding.prepare(valueToBind);
        }
        super.bind(jpaQuery, methodParameter, valueToBind, position);
    }

    private StringQuery.LikeBinding getBindingFor(Query jpaQuery, int position, Parameter methodParameter) {
        try {
            jpaQuery.getParameter(position);
            return this.query.getBindingFor(position);
        }
        catch (IllegalArgumentException o_O) {
            if (this.hasNamedParameter(jpaQuery)) {
                return this.query.getBindingFor(methodParameter.getName());
            }
            return null;
        }
    }
}

