/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.io.Serializable;
import java.util.Arrays;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.events.md.sharing.MetadataShare;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class UpdateOperations
implements ApplicationListener<MetadataShare> {
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private IMetadataIndexer metadataIndexer;
    @Autowired
    private IMetadataOperations metadataOperations;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    ServiceManager serviceManager;

    public void onApplicationEvent(MetadataShare event) {
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT)
    public void doBeforeCommit(MetadataShare event) {
        block22: {
            try {
                Log.trace((String)"geonetwork.datamanager", (Object)("UpdateOperationsListener: " + event.getRecord() + " op: " + event.getOp().getId().getOperationId()));
                AbstractMetadata md = this.metadataUtils.findOne(event.getRecord().intValue());
                if (md == null) {
                    return;
                }
                if (md instanceof MetadataDraft) {
                    Log.trace((String)"geonetwork.datamanager", (Object)("Draft privileges are handled on approved record: " + event.getOp()));
                    break block22;
                }
                MetadataDraft draft = this.metadataDraftRepository.findOneByUuid(md.getUuid());
                if (draft == null) break block22;
                try (ServiceContext context = this.serviceManager.createServiceContext("update_operations", -1);){
                    OperationAllowed op = event.getOp();
                    if (op.getId().getOperationId() == ReservedOperation.editing.getId()) {
                        Log.trace((String)"geonetwork.datamanager", (Object)("Updating privileges on draft " + draft.getId()));
                        Group g = (Group)this.groupRepository.findOne((Serializable)Integer.valueOf(op.getId().getGroupId()));
                        if (!g.isReserved()) {
                            try {
                                if (event.getType() == MetadataShare.Type.REMOVE) {
                                    Log.trace((String)"geonetwork.datamanager", (Object)("Removing editing on group " + op.getId().getGroupId() + " for draft " + draft.getId()));
                                    this.metadataOperations.forceUnsetOperation(context, draft.getId(), op.getId().getGroupId(), op.getId().getOperationId());
                                } else {
                                    Log.trace((String)"geonetwork.datamanager", (Object)("Adding editing on group " + op.getId().getGroupId() + " for draft " + draft.getId()));
                                    this.metadataOperations.forceSetOperation(context, draft.getId(), op.getId().getGroupId(), op.getId().getOperationId());
                                }
                                this.metadataIndexer.indexMetadata(Arrays.asList(String.valueOf(draft.getId())));
                            }
                            catch (Exception e) {
                                Log.error((String)"geonetwork.datamanager", (Object)"Error cascading operation to draft", (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                Log.error((String)"geonetwork.datamanager", (Object)("Couldn't update the operations of the draft " + event.getRecord()), (Throwable)e);
            }
        }
    }
}

