/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.affine.AffineOpImage;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class AffineBilinearOpImage
extends AffineOpImage {
    protected InterpolationBilinear interpB = null;
    protected byte[][] byteLookupTable;
    static final BorderExtender roiExtender = BorderExtender.createInstance((int)0);
    private boolean setDestinationNoData;

    public AffineBilinearOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, AffineTransform transform, Interpolation interp, double[] backgroundValues, boolean setDestinationNoData, boolean useROIAccessor, Range nodata) {
        super(source, extender, config, layout, transform, interp, backgroundValues);
        this.affineOpInitialization(source, interp, layout, backgroundValues, useROIAccessor, setDestinationNoData, nodata);
    }

    private void affineOpInitialization(RenderedImage source, Interpolation interp, ImageLayout layout, double[] backgroundValues, boolean useROIAccessor, boolean setDestinationNoData, Range nodata) {
        int i;
        SampleModel sm = source.getSampleModel();
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel && ImageUtil.isBinary((SampleModel)sm)) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        int numBands = this.getSampleModel().getNumBands();
        int srcDataType = sm.getDataType();
        Range nod = nodata;
        double[] destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues;
        }
        if (interp instanceof InterpolationBilinear) {
            this.interpB = (InterpolationBilinear)interp;
            this.interp = this.interpB;
            this.interpB.setROIBounds(this.roiBounds);
            if (nod == null) {
                nod = this.interpB.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpB.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useROIAccessor = useROIAccessor;
        }
        this.setDestinationNoData = setDestinationNoData;
        this.setBackground = setDestinationNoData;
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (srcDataType == 0 && this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                byte value = (byte)i;
                for (int b = 0; b < numBands; ++b) {
                    if (this.noData.contains(value)) {
                        if (setDestinationNoData) {
                            this.byteLookupTable[b][i] = this.destinationNoDataByte[b];
                            continue;
                        }
                        this.byteLookupTable[b][i] = 0;
                        if (i == 0) continue;
                        this.byteLookupTable[b][0] = 1;
                        continue;
                    }
                    this.byteLookupTable[b][i] = value;
                }
            }
        }
        if (this.destinationNoDataDouble != null) {
            this.setProperty("GC_NODATA", new NoDataContainer(this.destinationNoDataDouble));
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        int srcRectX = srcRect.x;
        int srcRectY = srcRect.y;
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useROIAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            } else {
                roiIter = RandomIterFactory.create((RenderedImage)this.srcROIImgExt, (Rectangle)this.roiRect, (boolean)true, (boolean)true);
            }
        }
        int dataType = dest.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.byteLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 3: {
                this.intLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(dataType, srcAccessor, destRect, srcRectX, srcRectY, dstAccessor, roiAccessor, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            int s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]] & 0xFF;
                            int s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]] & 0xFF;
                            int s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]] & 0xFF;
                            int s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]] & 0xFF;
                            float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                            float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                            float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                            int intResult = 0;
                            intResult = result > 254.5f ? 255 : (result < 0.5f ? 0 : (int)(result + 0.5f));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (byte)(intResult & 0xFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataByte[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]] & 0xFF;
                                int s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]] & 0xFF;
                                int s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]] & 0xFF;
                                int s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]] & 0xFF;
                                float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                int intResult = 0;
                                intResult = result > 254.5f ? 255 : (result < 0.5f ? 0 : (int)(result + 0.5f));
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (byte)(intResult & 0xFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataByte[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    int s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]] & 0xFF;
                                    int s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]] & 0xFF;
                                    int s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]] & 0xFF;
                                    int s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]] & 0xFF;
                                    float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                    float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                    float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                    int intResult = 0;
                                    intResult = result > 254.5f ? 255 : (result < 0.5f ? 0 : (int)(result + 0.5f));
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (byte)(intResult & 0xFF);
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataByte[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            boolean w11z;
                            byte s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            byte s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            byte s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            byte s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            boolean w00z = this.byteLookupTable[k2][s00 & 0xFF] == this.destinationNoDataByte[k2];
                            boolean w01z = this.byteLookupTable[k2][s01 & 0xFF] == this.destinationNoDataByte[k2];
                            boolean w10z = this.byteLookupTable[k2][s10 & 0xFF] == this.destinationNoDataByte[k2];
                            boolean bl = w11z = this.byteLookupTable[k2][s11 & 0xFF] == this.destinationNoDataByte[k2];
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)(s00 & 0xFF), (double)(s01 & 0xFF), (double)(s10 & 0xFF), (double)(s11 & 0xFF), (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataByte[k2]).doubleValue();
                            int intResult = 0;
                            intResult = result > 254.5 ? 255 : (result < 0.5 ? 0 : (int)(result + 0.5));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (byte)(intResult & 0xFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataByte[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            boolean w11z;
                            byte s00 = srcDataArrays[k25][posx + posy + bandOffsets[k25]];
                            byte s01 = srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]];
                            byte s10 = srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]];
                            byte s11 = srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]];
                            boolean w00z = this.byteLookupTable[k25][s00 & 0xFF] == this.destinationNoDataByte[k25];
                            boolean w01z = this.byteLookupTable[k25][s01 & 0xFF] == this.destinationNoDataByte[k25];
                            boolean w10z = this.byteLookupTable[k25][s10 & 0xFF] == this.destinationNoDataByte[k25];
                            boolean bl = w11z = this.byteLookupTable[k25][s11 & 0xFF] == this.destinationNoDataByte[k25];
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataByte[k25];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)(s00 & 0xFF), (double)(s01 & 0xFF), (double)(s10 & 0xFF), (double)(s11 & 0xFF), (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataByte[k25]).doubleValue();
                            int intResult = 0;
                            intResult = result > 254.5 ? 255 : (result < 0.5 ? 0 : (int)(result + 0.5));
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (byte)(intResult & 0xFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataByte[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                boolean w11z;
                                byte s00 = srcDataArrays[k26][posx + posy + bandOffsets[k26]];
                                byte s01 = srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]];
                                byte s10 = srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]];
                                byte s11 = srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]];
                                boolean w00z = this.byteLookupTable[k26][s00 & 0xFF] == this.destinationNoDataByte[k26];
                                boolean w01z = this.byteLookupTable[k26][s01 & 0xFF] == this.destinationNoDataByte[k26];
                                boolean w10z = this.byteLookupTable[k26][s10 & 0xFF] == this.destinationNoDataByte[k26];
                                boolean bl = w11z = this.byteLookupTable[k26][s11 & 0xFF] == this.destinationNoDataByte[k26];
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataByte[k26];
                                    continue;
                                }
                                double result = InterpolationBilinear.computeValueDouble((double)(s00 & 0xFF), (double)(s01 & 0xFF), (double)(s10 & 0xFF), (double)(s11 & 0xFF), (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataByte[k26]).doubleValue();
                                int intResult = 0;
                                intResult = result > 254.5 ? 255 : (result < 0.5 ? 0 : (int)(result + 0.5));
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = (byte)(intResult & 0xFF);
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataByte[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataByte[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void ushortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            int s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]] & 0xFFFF;
                            int s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]] & 0xFFFF;
                            int s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]] & 0xFFFF;
                            int s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]] & 0xFFFF;
                            float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                            float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                            float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                            int intResult = 0;
                            intResult = result > 65535.0f ? 65535 : ((double)result < 0.0 ? 0 : (int)(result + 0.5f));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)(intResult & 0xFFFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataUShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]] & 0xFFFF;
                                int s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]] & 0xFFFF;
                                int s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]] & 0xFFFF;
                                int s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]] & 0xFFFF;
                                float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                int intResult = 0;
                                intResult = result > 65535.0f ? 65535 : ((double)result < 0.0 ? 0 : (int)(result + 0.5f));
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (short)(intResult & 0xFFFF);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataUShort[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    int s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]] & 0xFFFF;
                                    int s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]] & 0xFFFF;
                                    int s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]] & 0xFFFF;
                                    int s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]] & 0xFFFF;
                                    float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                    float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                    float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                    int intResult = 0;
                                    intResult = result > 65535.0f ? 65535 : ((double)result < 0.0 ? 0 : (int)(result + 0.5f));
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (short)(intResult & 0xFFFF);
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataUShort[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            short s00 = (short)(srcDataArrays[k2][posx + posy + bandOffsets[k2]] & 0xFFFF);
                            short s01 = (short)(srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]] & 0xFFFF);
                            short s10 = (short)(srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]] & 0xFFFF);
                            short s11 = (short)(srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]] & 0xFFFF);
                            boolean w00 = !this.noData.contains(s00);
                            boolean w01 = !this.noData.contains(s01);
                            boolean w10 = !this.noData.contains(s10);
                            boolean w11 = !this.noData.contains(s11);
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataUShort[k2]).doubleValue();
                            int intResult = 0;
                            intResult = result > 65535.0 ? 65535 : (result < 0.0 ? 0 : (int)(result + 0.5));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)(intResult & 0xFFFF);
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            short s00 = (short)(srcDataArrays[k25][posx + posy + bandOffsets[k25]] & 0xFFFF);
                            short s01 = (short)(srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]] & 0xFFFF);
                            short s10 = (short)(srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]] & 0xFFFF);
                            short s11 = (short)(srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]] & 0xFFFF);
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataUShort[k25];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataUShort[k25]).doubleValue();
                            int intResult = 0;
                            intResult = result > 65535.0 ? 65535 : (result < 0.0 ? 0 : (int)(result + 0.5));
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (short)(intResult & 0xFFFF);
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataUShort[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                short s00 = (short)(srcDataArrays[k26][posx + posy + bandOffsets[k26]] & 0xFFFF);
                                short s01 = (short)(srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]] & 0xFFFF);
                                short s10 = (short)(srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]] & 0xFFFF);
                                short s11 = (short)(srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]] & 0xFFFF);
                                boolean w00z = this.noData.contains(s00);
                                boolean w01z = this.noData.contains(s01);
                                boolean w10z = this.noData.contains(s10);
                                boolean w11z = this.noData.contains(s11);
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataUShort[k26];
                                    continue;
                                }
                                double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataUShort[k26]).doubleValue();
                                int intResult = 0;
                                intResult = result > 65535.0 ? 65535 : (result < 0.0 ? 0 : (int)(result + 0.5));
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = (short)(intResult & 0xFFFF);
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataUShort[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataUShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void shortLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        short[][] dstDataArrays = dst.getShortDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            short s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            short s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            short s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            short s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                            float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                            float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                            int intResult = 0;
                            intResult = result > 32767.0f ? Short.MAX_VALUE : (result < -32768.0f ? Short.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)intResult;
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataShort[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                short s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]];
                                short s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]];
                                short s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]];
                                short s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]];
                                float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                int intResult = 0;
                                intResult = result > 32767.0f ? Short.MAX_VALUE : (result < -32768.0f ? Short.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = (short)intResult;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataShort[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    short s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]];
                                    short s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]];
                                    short s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]];
                                    short s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]];
                                    float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                    float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                    float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                    int intResult = 0;
                                    intResult = result > 32767.0f ? Short.MAX_VALUE : (result < -32768.0f ? Short.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = (short)intResult;
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataShort[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            short s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            short s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            short s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            short s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataShort[k2]).doubleValue();
                            int intResult = 0;
                            intResult = result > 32767.0 ? Short.MAX_VALUE : (result < -32768.0 ? Short.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = (short)intResult;
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            short s00 = srcDataArrays[k25][posx + posy + bandOffsets[k25]];
                            short s01 = srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]];
                            short s10 = srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]];
                            short s11 = srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataShort[k25];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataShort[k25]).doubleValue();
                            int intResult = 0;
                            intResult = result > 32767.0 ? Short.MAX_VALUE : (result < -32768.0 ? Short.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = (short)intResult;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataShort[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                short s00 = srcDataArrays[k26][posx + posy + bandOffsets[k26]];
                                short s01 = srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]];
                                short s10 = srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]];
                                short s11 = srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]];
                                boolean w00z = this.noData.contains(s00);
                                boolean w01z = this.noData.contains(s01);
                                boolean w10z = this.noData.contains(s10);
                                boolean w11z = this.noData.contains(s11);
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataShort[k26];
                                    continue;
                                }
                                double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataShort[k26]).doubleValue();
                                int intResult = 0;
                                intResult = result > 32767.0 ? Short.MAX_VALUE : (result < -32768.0 ? Short.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = (short)intResult;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataShort[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataShort[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void intLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            int s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            int s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            int s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            int s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                            float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                            float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                            int intResult = 0;
                            intResult = result > 2.1474836E9f ? Integer.MAX_VALUE : (result < -2.1474836E9f ? Integer.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = intResult;
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataInt[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                int s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]];
                                int s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]];
                                int s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]];
                                int s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]];
                                float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                int intResult = 0;
                                intResult = result > 2.1474836E9f ? Integer.MAX_VALUE : (result < -2.1474836E9f ? Integer.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = intResult;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataInt[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    int s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]];
                                    int s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]];
                                    int s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]];
                                    int s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]];
                                    float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                    float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                    float result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                    int intResult = 0;
                                    intResult = result > 2.1474836E9f ? Integer.MAX_VALUE : (result < -2.1474836E9f ? Integer.MIN_VALUE : (result > 0.0f ? (int)(result + 0.5f) : (int)(result - 0.5f)));
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = intResult;
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataInt[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            int s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            int s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            int s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            int s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k2]).doubleValue();
                            int intResult = 0;
                            intResult = result > 2.147483648E9 ? Integer.MAX_VALUE : (result < -2.147483648E9 ? Integer.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = intResult;
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            int s00 = srcDataArrays[k25][posx + posy + bandOffsets[k25]];
                            int s01 = srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]];
                            int s10 = srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]];
                            int s11 = srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataInt[k25];
                                continue;
                            }
                            double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k25]).doubleValue();
                            int intResult = 0;
                            intResult = result > 2.147483648E9 ? Integer.MAX_VALUE : (result < -2.147483648E9 ? Integer.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = intResult;
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataInt[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                int s00 = srcDataArrays[k26][posx + posy + bandOffsets[k26]];
                                int s01 = srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]];
                                int s10 = srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]];
                                int s11 = srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]];
                                boolean w00z = this.noData.contains(s00);
                                boolean w01z = this.noData.contains(s01);
                                boolean w10z = this.noData.contains(s10);
                                boolean w11z = this.noData.contains(s11);
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataInt[k26];
                                    continue;
                                }
                                double result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k26]).doubleValue();
                                int intResult = 0;
                                intResult = result > 2.147483648E9 ? Integer.MAX_VALUE : (result < -2.147483648E9 ? Integer.MIN_VALUE : (result > 0.0 ? (int)(result + 0.5) : (int)(result - 0.5)));
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = intResult;
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataInt[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataInt[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void floatLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            float result;
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            float s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            float s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            float s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            float s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                            float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result = (float)((double)(s1 - s0) * fracy + (double)s0);
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataFloat[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                float result;
                                float s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]];
                                float s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]];
                                float s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]];
                                float s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]];
                                float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = result = (float)((double)(s1 - s0) * fracy + (double)s0);
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataFloat[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    float result;
                                    float s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]];
                                    float s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]];
                                    float s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]];
                                    float s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]];
                                    float s0 = (float)((double)(s01 - s00) * fracx + (double)s00);
                                    float s1 = (float)((double)(s11 - s10) * fracx + (double)s10);
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = result = (float)((double)(s1 - s0) * fracy + (double)s0);
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataFloat[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            float result;
                            float s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            float s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            float s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            float s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                                continue;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)4, (double)this.destinationNoDataFloat[k2]).floatValue();
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            float result;
                            float s00 = srcDataArrays[k25][posx + posy + bandOffsets[k25]];
                            float s01 = srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]];
                            float s10 = srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]];
                            float s11 = srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataFloat[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)4, (double)this.destinationNoDataFloat[k25]).floatValue();
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataFloat[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                float result;
                                float s00 = srcDataArrays[k26][posx + posy + bandOffsets[k26]];
                                float s01 = srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]];
                                float s10 = srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]];
                                float s11 = srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]];
                                boolean w00z = this.noData.contains(s00);
                                boolean w01z = this.noData.contains(s01);
                                boolean w10z = this.noData.contains(s10);
                                boolean w11z = this.noData.contains(s11);
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataFloat[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)4, (double)this.destinationNoDataFloat[k26]).floatValue();
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataFloat[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataFloat[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }

    private void doubleLoop(int dataType, RasterAccessor src, Rectangle destRect, int srcRectX, int srcRectY, RasterAccessor dst, RasterAccessor roi, RandomIter roiIter) {
        int roiScanlineStride;
        int roiDataLength;
        byte[] roiDataArray;
        float src_rect_x1 = src.getX();
        float src_rect_y1 = src.getY();
        float src_rect_x2 = src_rect_x1 + (float)src.getWidth();
        float src_rect_y2 = src_rect_y1 + (float)src.getHeight();
        double fracx = 0.0;
        double fracy = 0.0;
        int dstOffset = 0;
        Point2D.Float dst_pt = new Point2D.Float();
        Point2D.Float src_pt = new Point2D.Float();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        int[] bandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int dst_num_bands = dst.getNumBands();
        int dst_min_x = destRect.x;
        int dst_min_y = destRect.y;
        int dst_max_x = destRect.x + destRect.width;
        int dst_max_y = destRect.y + destRect.height;
        if (this.useROIAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
            roiScanlineStride = roi.getScanlineStride();
        } else {
            roiDataArray = null;
            roiDataLength = 0;
            roiScanlineStride = 0;
        }
        if (this.caseA) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            double result;
                            int posx = (s_ix - srcRectX) * srcPixelStride;
                            int posy = (s_iy - srcRectY) * srcScanlineStride;
                            int posxhigh = posx + srcPixelStride;
                            int posyhigh = posy + srcScanlineStride;
                            double s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            double s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            double s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            double s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            double s0 = (s01 - s00) * fracx + s00;
                            double s1 = (s11 - s10) * fracx + s10;
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result = (s1 - s0) * fracy + s0;
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.caseB) {
            if (this.useROIAccessor) {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int k22;
                        int w11;
                        int baseIndex;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int w00index = baseIndex = posx / dst_num_bands + posyROI;
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + roiScanlineStride + 1;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                    dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = this.destinationNoDataDouble[k22];
                                }
                            }
                        } else {
                            for (k22 = 0; k22 < dst_num_bands; ++k22) {
                                double result;
                                double s00 = srcDataArrays[k22][posx + posy + bandOffsets[k22]];
                                double s01 = srcDataArrays[k22][posxhigh + posy + bandOffsets[k22]];
                                double s10 = srcDataArrays[k22][posx + posyhigh + bandOffsets[k22]];
                                double s11 = srcDataArrays[k22][posxhigh + posyhigh + bandOffsets[k22]];
                                double s0 = (s01 - s00) * fracx + s00;
                                double s1 = (s11 - s10) * fracx + s10;
                                dstDataArrays[k22][dstPixelOffset + dstBandOffsets[k22]] = result = (s1 - s0) * fracy + s0;
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            } else {
                for (int y = dst_min_y; y < dst_max_y; ++y) {
                    int k2;
                    int x;
                    int dstPixelOffset = dstOffset;
                    ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                    this.mapDestPoint(dst_pt, src_pt);
                    float s_x = (float)((Point2D)src_pt).getX();
                    float s_y = (float)((Point2D)src_pt).getY();
                    s_x = (float)((double)s_x - 0.5);
                    s_y = (float)((double)s_y - 0.5);
                    int s_ix = (int)Math.floor(s_x);
                    int s_iy = (int)Math.floor(s_y);
                    fracx = (double)s_x - (double)s_ix * 1.0;
                    fracy = (double)s_y - (double)s_iy * 1.0;
                    int ifracx = (int)Math.floor(fracx * 1048576.0);
                    int ifracy = (int)Math.floor(fracy * 1048576.0);
                    javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                    int clipMinX = (Integer)clipRange.getMinValue();
                    int clipMaxX = (Integer)clipRange.getMaxValue();
                    Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                    s_ix = startPts[0].x;
                    s_iy = startPts[0].y;
                    if (this.setDestinationNoData) {
                        for (x = dst_min_x; x < clipMinX; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    } else {
                        dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                    }
                    for (x = clipMinX; x < clipMaxX; ++x) {
                        int y0;
                        int posx = (s_ix - srcRectX) * srcPixelStride;
                        int posy = (s_iy - srcRectY) * srcScanlineStride;
                        int posxhigh = posx + srcPixelStride;
                        int posyhigh = posy + srcScanlineStride;
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                            int k23;
                            int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                            int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                            int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                            int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                            if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                if (this.setDestinationNoData) {
                                    for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                        dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = this.destinationNoDataDouble[k23];
                                    }
                                }
                            } else {
                                for (k23 = 0; k23 < dst_num_bands; ++k23) {
                                    double result;
                                    double s00 = srcDataArrays[k23][posx + posy + bandOffsets[k23]];
                                    double s01 = srcDataArrays[k23][posxhigh + posy + bandOffsets[k23]];
                                    double s10 = srcDataArrays[k23][posx + posyhigh + bandOffsets[k23]];
                                    double s11 = srcDataArrays[k23][posxhigh + posyhigh + bandOffsets[k23]];
                                    double s0 = (s01 - s00) * fracx + s00;
                                    double s1 = (s11 - s10) * fracx + s10;
                                    dstDataArrays[k23][dstPixelOffset + dstBandOffsets[k23]] = result = (s1 - s0) * fracy + s0;
                                }
                            }
                        } else if (this.setDestinationNoData) {
                            for (int k24 = 0; k24 < dst_num_bands; ++k24) {
                                dstDataArrays[k24][dstPixelOffset + dstBandOffsets[k24]] = this.destinationNoDataDouble[k24];
                            }
                        }
                        if (fracx < this.fracdx1) {
                            s_ix += this.incx;
                            fracx += this.fracdx;
                        } else {
                            s_ix += this.incx1;
                            fracx -= this.fracdx1;
                        }
                        if (fracy < this.fracdy1) {
                            s_iy += this.incy;
                            fracy += this.fracdy;
                        } else {
                            s_iy += this.incy1;
                            fracy -= this.fracdy1;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                        for (x = clipMaxX; x < dst_max_x; ++x) {
                            for (k2 = 0; k2 < dst_num_bands; ++k2) {
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                    }
                    dstOffset += dstScanlineStride;
                }
            }
        } else if (this.caseC) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                for (int x = dst_min_x; x < dst_max_x; ++x) {
                    int k2;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    if ((float)s_ix >= src_rect_x1 && (float)s_ix < src_rect_x2 - 1.0f && (float)s_iy >= src_rect_y1 && (float)s_iy < src_rect_y2 - 1.0f) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            double result;
                            double s00 = srcDataArrays[k2][posx + posy + bandOffsets[k2]];
                            double s01 = srcDataArrays[k2][posxhigh + posy + bandOffsets[k2]];
                            double s10 = srcDataArrays[k2][posx + posyhigh + bandOffsets[k2]];
                            double s11 = srcDataArrays[k2][posxhigh + posyhigh + bandOffsets[k2]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                                continue;
                            }
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k2]).doubleValue();
                        }
                    } else if (this.setDestinationNoData) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstOffset += dstScanlineStride;
            }
        } else if (this.useROIAccessor) {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int k25;
                    int w11;
                    int baseIndex;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posyROI = (s_iy - srcRectY) * roiScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int w00index = baseIndex = posx / dst_num_bands + posyROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanlineStride;
                    int w11index = baseIndex + roiScanlineStride + 1;
                    int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                    int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                    int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                    int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                    if (baseIndex > roiDataLength || w00 == 0 || w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                        if (this.setDestinationNoData) {
                            for (k25 = 0; k25 < dst_num_bands; ++k25) {
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                            }
                        }
                    } else {
                        for (k25 = 0; k25 < dst_num_bands; ++k25) {
                            double result;
                            double s00 = srcDataArrays[k25][posx + posy + bandOffsets[k25]];
                            double s01 = srcDataArrays[k25][posxhigh + posy + bandOffsets[k25]];
                            double s10 = srcDataArrays[k25][posx + posyhigh + bandOffsets[k25]];
                            double s11 = srcDataArrays[k25][posxhigh + posyhigh + bandOffsets[k25]];
                            boolean w00z = this.noData.contains(s00);
                            boolean w01z = this.noData.contains(s01);
                            boolean w10z = this.noData.contains(s10);
                            boolean w11z = this.noData.contains(s11);
                            if (w00z && w01z && w10z && w11z) {
                                if (!this.setDestinationNoData) continue;
                                dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = this.destinationNoDataDouble[k25];
                                continue;
                            }
                            dstDataArrays[k25][dstPixelOffset + dstBandOffsets[k25]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k25]).doubleValue();
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        } else {
            for (int y = dst_min_y; y < dst_max_y; ++y) {
                int k2;
                int x;
                int dstPixelOffset = dstOffset;
                ((Point2D)dst_pt).setLocation((double)dst_min_x + 0.5, (double)y + 0.5);
                this.mapDestPoint(dst_pt, src_pt);
                float s_x = (float)((Point2D)src_pt).getX();
                float s_y = (float)((Point2D)src_pt).getY();
                s_x = (float)((double)s_x - 0.5);
                s_y = (float)((double)s_y - 0.5);
                int s_ix = (int)Math.floor(s_x);
                int s_iy = (int)Math.floor(s_y);
                fracx = (double)s_x - (double)s_ix * 1.0;
                fracy = (double)s_y - (double)s_iy * 1.0;
                int ifracx = (int)Math.floor(fracx * 1048576.0);
                int ifracy = (int)Math.floor(fracy * 1048576.0);
                javax.media.jai.util.Range clipRange = this.performScanlineClipping(src_rect_x1, src_rect_y1, src_rect_x2, src_rect_y2, s_ix, s_iy, ifracx, ifracy, dst_min_x, dst_max_x, 0, 1, 0, 1);
                int clipMinX = (Integer)clipRange.getMinValue();
                int clipMaxX = (Integer)clipRange.getMaxValue();
                Point[] startPts = this.advanceToStartOfScanline(dst_min_x, clipMinX, s_ix, s_iy, ifracx, ifracy);
                s_ix = startPts[0].x;
                s_iy = startPts[0].y;
                if (this.setDestinationNoData) {
                    for (x = dst_min_x; x < clipMinX; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                } else {
                    dstPixelOffset += (clipMinX - dst_min_x) * dstPixelStride;
                }
                for (x = clipMinX; x < clipMaxX; ++x) {
                    int y0;
                    int posx = (s_ix - srcRectX) * srcPixelStride;
                    int posy = (s_iy - srcRectY) * srcScanlineStride;
                    int posxhigh = posx + srcPixelStride;
                    int posyhigh = posy + srcScanlineStride;
                    int x0 = src.getX() + posx / srcPixelStride;
                    if (this.roiBounds.contains(x0, y0 = src.getY() + posy / srcScanlineStride)) {
                        int k26;
                        int w00 = roiIter.getSample(x0, y0, 0) & 0xFF;
                        int w01 = roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        int w10 = roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        int w11 = roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            if (this.setDestinationNoData) {
                                for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataDouble[k26];
                                }
                            }
                        } else {
                            for (k26 = 0; k26 < dst_num_bands; ++k26) {
                                double result;
                                double s00 = srcDataArrays[k26][posx + posy + bandOffsets[k26]];
                                double s01 = srcDataArrays[k26][posxhigh + posy + bandOffsets[k26]];
                                double s10 = srcDataArrays[k26][posx + posyhigh + bandOffsets[k26]];
                                double s11 = srcDataArrays[k26][posxhigh + posyhigh + bandOffsets[k26]];
                                boolean w00z = this.noData.contains(s00);
                                boolean w01z = this.noData.contains(s01);
                                boolean w10z = this.noData.contains(s10);
                                boolean w11z = this.noData.contains(s11);
                                if (w00z && w01z && w10z && w11z) {
                                    if (!this.setDestinationNoData) continue;
                                    dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = this.destinationNoDataDouble[k26];
                                    continue;
                                }
                                dstDataArrays[k26][dstPixelOffset + dstBandOffsets[k26]] = result = InterpolationBilinear.computeValueDouble((double)s00, (double)s01, (double)s10, (double)s11, (boolean)w00z, (boolean)w01z, (boolean)w10z, (boolean)w11z, (double)fracx, (double)fracy, (int)5, (double)this.destinationNoDataDouble[k26]).doubleValue();
                            }
                        }
                    } else if (this.setDestinationNoData) {
                        for (int k27 = 0; k27 < dst_num_bands; ++k27) {
                            dstDataArrays[k27][dstPixelOffset + dstBandOffsets[k27]] = this.destinationNoDataDouble[k27];
                        }
                    }
                    if (fracx < this.fracdx1) {
                        s_ix += this.incx;
                        fracx += this.fracdx;
                    } else {
                        s_ix += this.incx1;
                        fracx -= this.fracdx1;
                    }
                    if (fracy < this.fracdy1) {
                        s_iy += this.incy;
                        fracy += this.fracdy;
                    } else {
                        s_iy += this.incy1;
                        fracy -= this.fracdy1;
                    }
                    dstPixelOffset += dstPixelStride;
                }
                if (this.setDestinationNoData && clipMinX <= clipMaxX) {
                    for (x = clipMaxX; x < dst_max_x; ++x) {
                        for (k2 = 0; k2 < dst_num_bands; ++k2) {
                            dstDataArrays[k2][dstPixelOffset + dstBandOffsets[k2]] = this.destinationNoDataDouble[k2];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                }
                dstOffset += dstScanlineStride;
            }
        }
    }
}

