/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroup_;
import org.fao.geonet.domain.UserSecurity_;
import org.fao.geonet.domain.User_;
import org.springframework.data.jpa.domain.Specification;

public final class UserSpecs {
    private UserSpecs() {
    }

    public static Specification<User> hasUserId(final int userId) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userIdAttributePath = root.get(User_.id);
                Predicate userIdEqualPredicate = cb.equal((Expression)userIdAttributePath, cb.literal((Object)userId));
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<User> hasProfile(final Profile profile) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path profilePath = root.get(User_.profile);
                Predicate userIdEqualPredicate = cb.equal((Expression)profilePath, cb.literal((Object)profile));
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<User> hasUserName(final String userName) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userNameAttributePath = root.get(User_.username);
                Predicate userIdEqualPredicate = cb.equal((Expression)userNameAttributePath, cb.literal((Object)userName));
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<User> hasEmail(final String email) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.isMember((Object)email, root.get(User_.emailAddresses));
            }
        };
    }

    public static Specification<User> hasNullAuthType() {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path authTypeAttributePath = root.get(User_.security).get(UserSecurity_.authType);
                Predicate userIdEqualPredicate = cb.isNull((Expression)authTypeAttributePath);
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<User> hasAuthType(final String authType) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path authTypeAttributePath = root.get(User_.security).get(UserSecurity_.authType);
                Predicate userIdEqualPredicate = cb.equal((Expression)authTypeAttributePath, (Object)authType);
                return userIdEqualPredicate;
            }
        };
    }

    public static Specification<User> userIsNameNotOneOf(final Collection<String> usernames) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(User_.username).in(usernames);
            }
        };
    }

    public static Specification<User> hasUserIdIn(final Collection<Integer> ids) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(User_.id).in(ids);
            }
        };
    }

    public static Specification<User> hasEnabled(final Boolean enabled) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path enabledAttributePath = root.get(User_.enabled);
                Predicate enabledEqualPredicate = cb.equal((Expression)enabledAttributePath, (Object)enabled);
                return enabledEqualPredicate;
            }
        };
    }

    public static Specification<User> loginDateBetweenAndByGroups(final ISODate loginDateFrom, final ISODate loginDateTo, final Collection<Integer> groups) {
        return new Specification<User>(){

            public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                query.distinct(true);
                Path lastLoginDateAttributePath = root.get(User_.lastLoginDate);
                Path userIdPath = root.get(User_.id);
                Predicate userLastLoginBetweenPredicate = cb.between((Expression)lastLoginDateAttributePath, (Comparable)((Object)loginDateFrom.toString()), (Comparable)((Object)loginDateTo.toString()));
                if (!groups.isEmpty()) {
                    Root userGroupRoot = query.from(UserGroup.class);
                    Path groupGPath = userGroupRoot.get(UserGroup_.group).get(Group_.id);
                    Path userGPath = userGroupRoot.get(UserGroup_.user).get(User_.id);
                    Predicate inGroups = groupGPath.in(groups);
                    userLastLoginBetweenPredicate = cb.and((Expression)cb.equal((Expression)userGPath, (Expression)userIdPath), (Expression)cb.and((Expression)userLastLoginBetweenPredicate, (Expression)inGroups));
                }
                return userLastLoginBetweenPredicate;
            }
        };
    }
}

