/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.UserGroup_;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserGroupRepositoryCustom;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public class UserGroupRepositoryImpl
implements UserGroupRepositoryCustom {
    @PersistenceContext
    private EntityManager _entityManager;

    @Override
    public List<Integer> findGroupIds(Specification<UserGroup> spec) {
        return this.findIdsBy(spec, UserGroupId_.groupId);
    }

    @Override
    public List<Integer> findUserIds(Specification<UserGroup> spec) {
        return this.findIdsBy(spec, UserGroupId_.userId);
    }

    @Override
    @Transactional
    public int deleteAllByIdAttribute(SingularAttribute<UserGroupId, Integer> idAttribute, Collection<Integer> ids) {
        String userIdPath = SortUtils.createPath(UserGroup_.id, idAttribute);
        StringBuilder idString = new StringBuilder();
        for (Integer id : ids) {
            if (idString.length() > 0) {
                idString.append(",");
            }
            idString.append(id);
        }
        String qlString = "DELETE FROM " + UserGroup.class.getSimpleName() + " WHERE " + userIdPath + " IN (" + idString + ")";
        int deleted = this._entityManager.createQuery(qlString).executeUpdate();
        this._entityManager.flush();
        this._entityManager.clear();
        return deleted;
    }

    private List<Integer> findIdsBy(Specification<UserGroup> spec, SingularAttribute<UserGroupId, Integer> groupId) {
        CriteriaBuilder builder = this._entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Integer.class);
        Root from = query.from(UserGroup.class);
        query.select((Selection)from.get(UserGroup_.id).get(groupId));
        Predicate predicate = spec.toPredicate(from, query, builder);
        query.where((Expression)predicate);
        query.distinct(true);
        return this._entityManager.createQuery(query).getResultList();
    }

    @Override
    public void updateUserGroups(int userId, Set<UserGroup> newUserGroups) {
        UserGroupRepository userGroupRepository = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        List currentUserGroupLists = userGroupRepository.findAll(UserGroupSpecs.hasUserId(userId));
        HashSet currentUserGroups = new HashSet(currentUserGroupLists);
        if (!newUserGroups.equals(currentUserGroups)) {
            userGroupRepository.deleteAll(UserGroupSpecs.hasUserId(userId));
            for (UserGroup ug : newUserGroups) {
                userGroupRepository.save(ug);
            }
        }
    }
}

