/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.userfeedback;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.userfeedback.Keyword;
import org.fao.geonet.domain.userfeedback.Rating;

@Entity(name="GUF_UserFeedback")
@Table(name="GUF_UserFeedbacks")
public class UserFeedback
extends GeonetEntity
implements Serializable {
    private static final long serialVersionUID = -5537639171291203188L;
    private String uuid;
    private String commentText;
    private List<Rating> detailedRatingList;
    private Metadata metadata;
    private UserFeedback parent;
    private User authorId;
    private String authorName;
    private String authorOrganization;
    private String authorEmail;
    private int authorPrivacy;
    private Set<Keyword> keywords;
    private UserRatingStatus status;
    private User approver;
    private Date creationDate;

    @Id
    public String getUuid() {
        return this.uuid;
    }

    @Column
    public String getCommentText() {
        return this.commentText;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<Rating> getDetailedRatingList() {
        return this.detailedRatingList;
    }

    @ManyToOne
    @JoinColumn(name="metadata_uuid", referencedColumnName="uuid")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @ManyToOne
    @JoinColumn(name="parent_uuid", referencedColumnName="uuid")
    public UserFeedback getParent() {
        return this.parent;
    }

    @ManyToOne
    @Nullable
    @JoinColumn(name="author_id", referencedColumnName="id")
    public User getAuthorId() {
        return this.authorId;
    }

    @Column
    @Nullable
    public String getAuthorName() {
        return this.authorName;
    }

    @Column
    @Nullable
    public String getAuthorOrganization() {
        return this.authorOrganization;
    }

    @Column
    @Nullable
    public String getAuthorEmail() {
        return this.authorEmail;
    }

    @Column
    @Nullable
    public int getAuthorPrivacy() {
        return this.authorPrivacy;
    }

    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="GUF_userfeedback_keyword", joinColumns={@JoinColumn(name="userfeedback_uuid", referencedColumnName="uuid")}, inverseJoinColumns={@JoinColumn(name="keyword_id", referencedColumnName="id")})
    public Set<Keyword> getKeywords() {
        return this.keywords;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public UserRatingStatus getStatus() {
        return this.status;
    }

    @ManyToOne
    @Nullable
    @JoinColumn(name="approver_id", referencedColumnName="id")
    public User getApprover() {
        return this.approver;
    }

    @Column
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid == null || uuid.equals("") ? UUID.randomUUID().toString() : uuid;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public void setDetailedRatingList(List<Rating> detailedRatingList) {
        this.detailedRatingList = detailedRatingList;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setParent(UserFeedback parent) {
        this.parent = parent;
    }

    public void setAuthorId(User authorId) {
        this.authorId = authorId;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public void setAuthorOrganization(String authorOrganization) {
        this.authorOrganization = authorOrganization;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public void setAuthorPrivacy(int authorPrivacy) {
        this.authorPrivacy = authorPrivacy;
    }

    public void setKeywords(Set<Keyword> keywords) {
        this.keywords = keywords;
    }

    public void setStatus(UserRatingStatus status) {
        this.status = status;
    }

    public void setApprover(User approver) {
        this.approver = approver;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        UserFeedback rhs = (UserFeedback)obj;
        return this.uuid == null ? false : this.uuid.equals(rhs.uuid);
    }

    public int hashCode() {
        int hashCode = 17;
        return hashCode += this.uuid == null ? 0 : this.uuid.hashCode() * 31;
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getUuid());
    }

    public static enum UserRatingStatus {
        PUBLISHED,
        WAITING_FOR_APPROVAL;

    }
}

