/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Service;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="ServiceParameters")
@SequenceGenerator(name="serviceparameters_id_seq", initialValue=100, allocationSize=1)
public class ServiceParam
extends GeonetEntity {
    static final String ID_SEQ_NAME = "serviceparameters_id_seq";
    private static final List<Character> LEGALVALUES = Lists.newArrayList((Object[])new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf(' '), null});
    private int id;
    private Service service;
    private String name;
    private String value;
    private Character occur = Character.valueOf('+');

    public ServiceParam() {
    }

    public ServiceParam(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="serviceparameters_id_seq")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public ServiceParam setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ServiceParam setValue(String value) {
        this.value = value;
        return this;
    }

    @JsonIgnore
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(referencedColumnName="id", name="service")
    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Character getOccur() {
        if (this.occur == null) {
            return Character.valueOf('+');
        }
        return this.occur;
    }

    public void setOccur(Character occur) {
        if (!LEGALVALUES.contains(occur)) {
            throw new IllegalArgumentException(occur + " is not a legal occur value.  Legal values are: " + LEGALVALUES);
        }
        this.occur = occur;
    }
}

