/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.entitylistener.MetadataCategoryEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Cacheable
@Table(name="Categories")
@EntityListeners(value={MetadataCategoryEntityListenerManager.class})
@SequenceGenerator(name="metadata_category_id_seq", initialValue=100, allocationSize=1)
public class MetadataCategory
extends Localized
implements Serializable {
    private static final Set<String> EXCLUDE_FROM_XML = Sets.newHashSet((Object[])new String[]{"getRecords"});
    static final String ID_SEQ_NAME = "metadata_category_id_seq";
    private int _id;
    private String _name;
    private Set<Metadata> _records = new HashSet<Metadata>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadata_category_id_seq")
    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    @Column(nullable=false)
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="CategoriesDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    @ManyToMany(mappedBy="metadataCategories", fetch=FetchType.LAZY)
    @Nonnull
    @JsonIgnore
    public Set<Metadata> getRecords() {
        return this._records;
    }

    protected void setRecords(@Nonnull Set<Metadata> records) {
        this._records = records;
    }

    @Override
    protected Set<String> propertiesToExcludeFromXml() {
        return EXCLUDE_FROM_XML;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataCategory category = (MetadataCategory)o;
        return this._id == category._id;
    }

    public int hashCode() {
        return this._id;
    }
}

