/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.lucene.document.Document;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.userfeedback.UserFeedback;
import org.fao.geonet.entitylistener.MetadataEntityListenerManager;

@Entity
@Table(name="Metadata")
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={MetadataEntityListenerManager.class})
public class Metadata
extends AbstractMetadata
implements Serializable {
    private static final long serialVersionUID = -5557599895424227101L;
    public static final String TABLENAME = "Metadata";
    public static final String METADATA_CATEG_JOIN_TABLE_NAME = "MetadataCateg";
    private List<UserFeedback> userFeedbacks;

    public static Metadata createFromLuceneIndexDocument(Document doc) {
        Metadata metadata = new Metadata();
        Metadata.transform(doc, metadata);
        return metadata;
    }

    @ManyToMany(cascade={CascadeType.DETACH, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="MetadataCateg", joinColumns={@JoinColumn(name="metadataId")}, inverseJoinColumns={@JoinColumn(name="categoryId")})
    @Nonnull
    public Set<MetadataCategory> getMetadataCategories() {
        return this.metadataCategories;
    }

    protected void setMetadataCategories(@Nonnull Set<MetadataCategory> categories) {
        this.metadataCategories = categories;
    }

    @OneToMany(mappedBy="metadata", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<UserFeedback> getUserFeedbacks() {
        return this.userFeedbacks;
    }

    public void setUserFeedbacks(@Nonnull List<UserFeedback> userFeedbacks) {
        this.userFeedbacks = userFeedbacks;
    }
}

