/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.domain.GeonetEntity;
import org.jdom.Element;

public abstract class Localized
extends GeonetEntity {
    private Map<String, String> _labelTranslations = new HashMap<String, String>();

    public static Map<String, String> translationXmlToLangMap(List<Element> translations) {
        HashMap labelTranslations = Maps.newHashMap();
        if (translations != null) {
            for (Element translation : translations) {
                String langId = translation.getName();
                String value = translation.getText();
                labelTranslations.put(langId, value);
            }
        }
        return labelTranslations;
    }

    @Nonnull
    @JsonProperty(value="label")
    public Map<String, String> getLabelTranslations() {
        return this._labelTranslations;
    }

    @JsonIgnore
    public void setLabelTranslationsFromElement(List<Element> translations) {
        this.getLabelTranslations().clear();
        this.getLabelTranslations().putAll(Localized.translationXmlToLangMap(translations));
    }

    @Nullable
    public String getLabel(@Nonnull String threeLetterLanguageCode) {
        return this._labelTranslations.get(threeLetterLanguageCode);
    }

    public void setLabelTranslations(@Nonnull Map<String, String> localizedTranslations) {
        this._labelTranslations = localizedTranslations;
    }
}

