/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.locationtech.jts.util.Assert;

@Embeddable
@Access(value=AccessType.PROPERTY)
public class HarvesterDataId
implements Serializable {
    private String harvesterUuid;
    private String key;

    public HarvesterDataId() {
    }

    public HarvesterDataId(String harvesterUuid, String key) {
        this.setHarvesterUuid(harvesterUuid);
        this.setKey(key);
    }

    public String getHarvesterUuid() {
        return this.harvesterUuid;
    }

    public void setHarvesterUuid(String harvesterUuid) {
        this.harvesterUuid = harvesterUuid;
    }

    @Column(name="keyvalue", nullable=false, length=255)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Assert.isTrue((key.length() <= 255 ? 1 : 0) != 0);
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarvesterDataId that = (HarvesterDataId)o;
        if (!this.harvesterUuid.equals(that.harvesterUuid)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.harvesterUuid.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public String toString() {
        return "ID {harvesterUuid='" + this.harvesterUuid + '\'' + ", key='" + this.key + '\'' + '}';
    }
}

