/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.HarvesterDataId;
import org.fao.geonet.domain.ISODate;
import org.locationtech.jts.util.Assert;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="HarvesterData")
public class HarvesterData {
    private HarvesterDataId id;
    private String value;

    @Id
    public HarvesterDataId getId() {
        return this.id;
    }

    public void setId(HarvesterDataId id) {
        this.id = id;
    }

    @Column(nullable=false, length=255)
    public String getValue() {
        return this.value;
    }

    public void setValue(ISODate value) {
        this.setValue(value.getDateAndTime());
    }

    public void setValue(String value) {
        Assert.isTrue((value.length() <= 255 ? 1 : 0) != 0);
        this.value = value;
    }

    @Transient
    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    @Transient
    public long getValueAsLong() {
        return Integer.parseInt(this.value);
    }

    public void setValue(long value) {
        this.setValue(Long.toString(value));
    }

    @Transient
    public boolean getValueAsBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.toString(value));
    }

    @Transient
    public ISODate getValueAsDate() {
        return new ISODate(this.value);
    }

    public String toString() {
        return "HarvesterData{id=" + this.id + ", value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarvesterData that = (HarvesterData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

