/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.params.HttpMethodParams;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;
import ucar.unidata.util.Urlencoded;

public class HttpClientManager {
    private static boolean debug = false;
    private static int timeout = 0;

    public static void init(CredentialsProvider provider, String userAgent) {
        if (provider != null) {
            HTTPSession.setGlobalCredentialsProvider(provider);
        }
        if (userAgent != null) {
            HTTPSession.setGlobalUserAgent(userAgent + "/NetcdfJava/HttpClient");
        } else {
            HTTPSession.setGlobalUserAgent("NetcdfJava/HttpClient");
        }
    }

    public static void clearState() {
    }

    @Urlencoded
    public static String getContentAsString(String urlencoded) throws IOException {
        return HttpClientManager.getContentAsString(null, urlencoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Urlencoded
    public static String getContentAsString(HTTPSession session, String urlencoded) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = new HTTPSession();
            }
            HTTPMethod m = HTTPMethod.Get(useSession);
            m.execute(urlencoded);
            String string = m.getResponseAsString();
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int putContent(String urlencoded, String content) throws IOException {
        HTTPSession session = null;
        try {
            Header locationHeader;
            session = new HTTPSession();
            HTTPMethod m = HTTPMethod.Put(session);
            m.setRequestContentAsString(content);
            m.execute(urlencoded);
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationHeader = m.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getUrlContentsAsString(String urlencoded, int maxKbytes) {
        return HttpClientManager.getUrlContentsAsString(null, urlencoded, maxKbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getUrlContentsAsString(HTTPSession session, String urlencoded, int maxKbytes) {
        HTTPSession useSession = session;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = new HTTPSession();
            }
            HTTPMethod m = HTTPMethod.Get(useSession);
            m.setFollowRedirects(true);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            int status = m.execute(urlencoded);
            if (status != 200) {
                throw new RuntimeException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                byte[] body = m.getResponseAsBytes();
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                String string2 = HttpClientManager.readContents(is, charset, maxKbytes);
                return string2;
            }
            if (encoding != null && encoding.equals("gzip")) {
                byte[] body = m.getResponseAsBytes();
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
                String string3 = HttpClientManager.readContents(is, charset, maxKbytes);
                return string3;
            }
            byte[] body = m.getResponseAsBytes(maxKbytes * 1000);
            String string4 = new String(body, charset);
            return string4;
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            String string = null;
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy(is, bout, 1000 * maxKbytes);
        return bout.toString(charset);
    }

    public static void copyUrlContentsToFile(String urlencoded, File file) throws HTTPException {
        HttpClientManager.copyUrlContentsToFile(null, urlencoded, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyUrlContentsToFile(HTTPSession session, String urlencoded, File file) throws HTTPException {
        HTTPSession useSession = session;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = new HTTPSession();
            }
            HTTPMethod m = HTTPMethod.Get(useSession);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            int status = m.execute(urlencoded);
            if (status != 200) {
                throw new RuntimeException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile(is, file.getPath());
            } else if (encoding != null && encoding.equals("gzip")) {
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                IO.writeToFile(is, file.getPath());
            } else {
                IO.writeToFile(m.getResponseAsStream(), file.getPath());
            }
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static long appendUrlContentsToFile(String urlencoded, File file, long start, long end) throws HTTPException {
        return HttpClientManager.appendUrlContentsToFile(null, urlencoded, file, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long appendUrlContentsToFile(HTTPSession session, String urlencoded, File file, long start, long end) throws HTTPException {
        HTTPSession useSession = session;
        long nbytes = 0L;
        try {
            Header h;
            String encoding;
            if (useSession == null) {
                useSession = new HTTPSession();
            }
            HTTPMethod m = HTTPMethod.Get(useSession);
            m.setRequestHeader("Accept-Encoding", "gzip,deflate");
            m.setRequestHeader("Range", "bytes=" + start + "-" + end);
            int status = m.execute(urlencoded);
            if (status != 200 && status != 206) {
                throw new RuntimeException("failed status = " + status);
            }
            String charset = m.getResponseCharSet();
            if (charset == null) {
                charset = "UTF-8";
            }
            String string = encoding = (h = m.getResponseHeader("content-encoding")) == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                nbytes = IO.appendToFile(is, file.getPath());
            } else if (encoding != null && encoding.equals("gzip")) {
                BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                nbytes = IO.appendToFile(is, file.getPath());
            } else {
                nbytes = IO.appendToFile(m.getResponseAsStream(), file.getPath());
            }
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
        }
        finally {
            if (session == null && useSession != null) {
                session.close();
            }
        }
        return nbytes;
    }

    public static void showHttpRequestInfo(Formatter f, HttpMethodBase m) {
        f.format("HttpClient request %s %s %n", m.getName(), m.getPath());
        f.format("   do Authentication=%s%n", m.getDoAuthentication());
        f.format("   follow Redirects =%s%n", m.getFollowRedirects());
        f.format("   effectiveVersion =%s%n", m.getEffectiveVersion());
        f.format("   hostAuthState    =%s%n", m.getHostAuthState());
        HttpMethodParams p = m.getParams();
        f.format("   cookie policy    =%s%n", p.getCookiePolicy());
        f.format("   http version     =%s%n", p.getVersion());
        f.format("   timeout (msecs)  =%d%n", p.getSoTimeout());
        f.format("   virtual host     =%s%n", p.getVirtualHost());
        f.format("Request Headers = %n", new Object[0]);
        Header[] heads = m.getRequestHeaders();
        for (int i = 0; i < heads.length; ++i) {
            f.format("  %s", heads[i]);
        }
        f.format("%n", new Object[0]);
    }

    public static void showHttpResponseInfo(Formatter f, HttpMethodBase m) {
        f.format("HttpClient response status = %s%n", m.getStatusLine());
        f.format("Reponse Headers = %n", new Object[0]);
        Header[] heads = m.getResponseHeaders();
        for (int i = 0; i < heads.length; ++i) {
            f.format("  %s", heads[i]);
        }
        f.format("%n", new Object[0]);
    }
}

