/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.point.MultipleNestedPointCollectionImpl;
import ucar.nc2.ft.point.NestedPointCollectionIteratorFiltered;
import ucar.nc2.ft.point.StationHelper;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationProfileCollectionImpl
extends MultipleNestedPointCollectionImpl
implements StationProfileFeatureCollection {
    protected StationHelper stationHelper;
    protected NestedPointFeatureCollectionIterator localIterator;

    public StationProfileCollectionImpl(String name) {
        super(name, FeatureType.STATION_PROFILE);
    }

    protected abstract void initStationHelper();

    @Override
    public List<Station> getStations() {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations();
    }

    @Override
    public List<Station> getStations(List<String> stnNames) {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations(stnNames);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getBoundingBox();
    }

    @Override
    public StationProfileCollectionImpl subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        return new StationProfileFeatureCollectionSubset(this, stations);
    }

    @Override
    public StationProfileCollectionImpl subset(LatLonRect boundingBox) throws IOException {
        return this.subset((List)this.getStations(boundingBox));
    }

    @Override
    public StationProfileFeature getStationProfileFeature(Station s) throws IOException {
        return (StationProfileFeature)s;
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationProfileFeatureCollection does not implement getPointFeatureCollectionIterator()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public StationProfileFeature next() throws IOException {
        return (StationProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getNestedPointFeatureCollectionIterator(-1);
    }

    public int compareTo(Station so) {
        return this.name.compareTo(so.getName());
    }

    private class StationProfileFeatureCollectionSubset
    extends StationProfileCollectionImpl {
        StationProfileCollectionImpl from;

        StationProfileFeatureCollectionSubset(StationProfileCollectionImpl from, List<Station> stations) {
            super(from.getName());
            this.from = from;
            this.stationHelper = new StationHelper();
            this.stationHelper.setStations(stations);
        }

        @Override
        protected void initStationHelper() {
        }

        @Override
        public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new NestedPointCollectionIteratorFiltered(this.from.getNestedPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements NestedPointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(NestedPointFeatureCollection pointFeatureCollection) {
                StationProfileFeature stationFeature = (StationProfileFeature)pointFeatureCollection;
                return StationProfileFeatureCollectionSubset.this.stationHelper.getStation(stationFeature.getName()) != null;
            }
        }
    }
}

