/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.wcs.v1_0_0_Plus.WcsException;

public class ExceptionReport {
    protected static final Namespace ogcNS = Namespace.getNamespace((String)"http://www.opengis.net/ogc");
    private Document exceptionReport;

    public ExceptionReport(WcsException exception) {
        this(Collections.singletonList(exception));
    }

    public ExceptionReport(List<WcsException> exceptions) {
        Element rootElem = new Element("ServiceExceptionReport", ogcNS);
        rootElem.addNamespaceDeclaration(ogcNS);
        rootElem.setAttribute("version", "1.2.0");
        if (exceptions != null) {
            for (WcsException curException : exceptions) {
                Element exceptionElem = new Element("ServiceException", ogcNS);
                if (curException.getCode() != null && !curException.getCode().equals((Object)WcsException.Code.UNKNOWN)) {
                    exceptionElem.setAttribute("code", curException.getCode().toString());
                }
                if (curException.getLocator() != null && !curException.getLocator().equals("")) {
                    exceptionElem.setAttribute("locator", curException.getLocator());
                }
                if (curException.getTextMessages() != null) {
                    for (String curMessage : curException.getTextMessages()) {
                        exceptionElem.addContent(curMessage);
                    }
                }
                rootElem.addContent((Content)exceptionElem);
            }
        }
        this.exceptionReport = new Document(rootElem);
    }

    public Document getExceptionReport() {
        return this.exceptionReport;
    }

    public void writeExceptionReport(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.exceptionReport, (Writer)pw);
    }
}

