/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml2.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GMLCoordinatesTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;

    public GMLCoordinatesTypeBinding(CoordinateSequenceFactory csFactory) {
        this.csFactory = csFactory;
    }

    public QName getTarget() {
        return GML.CoordinatesType;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String decimal = ".";
        String cs = ",";
        String ts = " ";
        if (node.getAttribute("decimal") != null) {
            decimal = (String)node.getAttribute("decimal").getValue();
        }
        if (node.getAttribute("cs") != null) {
            cs = (String)node.getAttribute("cs").getValue();
        }
        if (node.getAttribute("ts") != null) {
            ts = (String)node.getAttribute("ts").getValue();
        }
        String text = instance.getText();
        String anyBlankSeq = "\\s+";
        String singleSpace = " ";
        text = text.replaceAll("\\s+", " ");
        StringTokenizer tuples = new StringTokenizer(text, ts);
        CoordinateSequence seq = null;
        int i = 0;
        int ncoords = tuples.countTokens();
        if (cs.equals(ts)) {
            ncoords /= 2;
        }
        while (tuples.hasMoreTokens()) {
            String tuple = tuples.nextToken();
            String[] oords = tuple.split(cs);
            if (cs.equals(ts) && oords.length == 1 && tuples.hasMoreTokens()) {
                String tempX = oords[0];
                oords = new String[]{tempX, tuples.nextToken()};
            }
            String x = null;
            String y = null;
            String z = null;
            String string = x = ".".equals(decimal) ? oords[0] : oords[0].replaceAll(decimal, ".");
            if (oords.length > 1) {
                String string2 = y = ".".equals(decimal) ? oords[1] : oords[1].replaceAll(decimal, ".");
            }
            if (oords.length > 2) {
                String string3 = z = ".".equals(decimal) ? oords[2] : oords[2].replaceAll(decimal, ".");
            }
            if (seq == null) {
                seq = JTS.createCS((CoordinateSequenceFactory)this.csFactory, (int)ncoords, (int)oords.length);
            }
            seq.setOrdinate(i, 0, Double.parseDouble(x));
            if (y != null) {
                seq.setOrdinate(i, 1, Double.parseDouble(y));
            }
            if (z != null) {
                seq.setOrdinate(i, 2, Double.parseDouble(z));
            }
            ++i;
        }
        return seq;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence coordinates = (CoordinateSequence)object;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < coordinates.size(); ++i) {
            boolean z;
            boolean y;
            Coordinate c = coordinates.getCoordinate(i);
            buf.append(c.x);
            boolean bl = y = coordinates.getDimension() > 1 && !Double.valueOf(c.y).isNaN();
            if (y) {
                buf.append("," + c.y);
            }
            boolean bl2 = z = y && coordinates.getDimension() > 2 && !Double.valueOf(c.getZ()).isNaN();
            if (z) {
                buf.append("," + c.getZ());
            }
            if (i >= coordinates.size() - 1) continue;
            buf.append(" ");
        }
        value.appendChild(document.createTextNode(buf.toString()));
        return value;
    }
}

